/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.AbstractTopLevelResourceType;
import org.opennms.netmgt.dao.support.LazyChildResourceLoader;
import org.opennms.netmgt.dao.support.NodeSourceResourceType;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class NodeResourceType
extends AbstractTopLevelResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private final ResourceDao m_resourceDao;
    private final NodeDao m_nodeDao;

    public NodeResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Node";
    }

    public String getName() {
        return "node";
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/node.jsp?node=" + resource.getName();
    }

    @Override
    public List<OnmsResource> getTopLevelResources() {
        return Collections.emptyList();
    }

    @Override
    public OnmsResource getResourceByName(String nodeIdStr) {
        int nodeId;
        try {
            nodeId = Integer.parseInt(nodeIdStr);
        }
        catch (NumberFormatException e) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeIdStr, "Top-level resource of type node is not numeric: " + nodeIdStr, null);
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeIdStr, "Top-level resource of type node could not be found: " + nodeIdStr, null);
        }
        return this.createResourceForNode(node);
    }

    protected static ResourcePath getResourcePathForNode(OnmsNode node) {
        return ResourcePath.get((String[])new String[]{"snmp", Integer.toString(node.getId())});
    }

    protected OnmsResource createResourceForNode(OnmsNode node) {
        ResourcePath path = NodeResourceType.getResourcePathForNode(node);
        LazyChildResourceLoader loader = new LazyChildResourceLoader(this.m_resourceDao);
        OnmsResource resource = new OnmsResource(Integer.toString(node.getId()), node.getLabel(), (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader), path);
        resource.setEntity((OnmsEntity)node);
        loader.setParent(resource);
        return resource;
    }

    public static boolean isNode(OnmsResource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceType() instanceof NodeResourceType || resource.getResourceType() instanceof NodeSourceResourceType;
    }
}

