/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.NullRrdStrategy;
import org.opennms.netmgt.rrd.RrdStrategy;

public class NodeSnmpResourceTypeTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private NodeDao m_nodeDao = (NodeDao)EasyMock.createNiceMock(NodeDao.class);
    private ResourceDao m_resourceDao = (ResourceDao)EasyMock.createNiceMock(ResourceDao.class);

    @Test
    public void canGetChildByName() throws IOException {
        NullRrdStrategy rrdStrategy = new NullRrdStrategy();
        FilesystemResourceStorageDao resourceStorageDao = new FilesystemResourceStorageDao();
        resourceStorageDao.setRrdDirectory(this.tempFolder.getRoot());
        resourceStorageDao.setRrdStrategy((RrdStrategy)rrdStrategy);
        File nodeSnmpFolder = this.tempFolder.newFolder(new String[]{"snmp", "1"});
        File rrd = new File(nodeSnmpFolder, "ds" + rrdStrategy.getDefaultFileExtension());
        rrd.createNewFile();
        NodeSnmpResourceType nodeSnmpResourceType = new NodeSnmpResourceType((ResourceStorageDao)resourceStorageDao);
        OnmsResource parent = this.getNodeResource(1);
        OnmsResource resource = nodeSnmpResourceType.getChildByName(parent, new String(""));
        Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)resource.getId());
        Assert.assertEquals((Object)parent, (Object)resource.getParent());
    }

    private OnmsResource getNodeResource(int nodeId) {
        NodeResourceType nodeResourceType = new NodeResourceType(this.m_resourceDao, this.m_nodeDao);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        node.setLabel("Node" + nodeId);
        return nodeResourceType.createResourceForNode(node);
    }
}

