/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.dao.support.PropertiesGraphDao;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.test.FileAnticipator;
import org.springframework.core.io.Resource;

public class PropertiesGraphDaoITCase {
    protected static final Map<String, Resource> s_emptyMap = new HashMap<String, Resource>();
    protected static final String s_prefab = "command.prefix=foo\noutput.mime=foo\n\nreports=mib2.HCbits, mib2.bits, mib2.discards\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\" \\\n DEF:octIn={rrd1}:ifHCInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifHCOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.bits.name=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\" \\\n DEF:octIn={rrd1}:ifInOctets:AVERAGE \\\n DEF:octOut={rrd2}:ifOutOctets:AVERAGE \\\n CDEF:bitsIn=octIn,8,* \\\n CDEF:bitsOut=octOut,8,* \\\n CDEF:totBits=octIn,octOut,+,8,* \\\n AREA:totBits#00ff00:\"Total\" \\\n GPRINT:totBits:AVERAGE:\" Avg  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsIn#0000ff:\"Bits In\" \\\n GPRINT:bitsIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:bitsOut#ff0000:\"Bits Out\" \\\n GPRINT:bitsOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:bitsOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\" \\\n DEF:octIn={rrd1}:ifInDiscards:AVERAGE \\\n DEF:octOut={rrd2}:ifOutDiscards:AVERAGE \\\n LINE2:octIn#0000ff:\"Discards In\" \\\n GPRINT:octIn:AVERAGE:\" Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octIn:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \\\n LINE2:octOut#ff0000:\"Discards Out\" \\\n GPRINT:octOut:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MIN:\"Min  \\\\: %8.2lf %s\" \\\n GPRINT:octOut:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"\n";
    protected static final String s_adhoc = "command.prefix=${install.rrdtool.bin} graph - --imgformat PNG --start {1} --end {2}\noutput.mime=image/png\nadhoc.command.title=--title=\"{3}\"\nadhoc.command.ds=DEF:{4}={0}:{5}:{6}\nadhoc.command.graphline={7}:{4}#{8}:\"{9}\"\n";
    protected static final String s_responsePrefab = "command.prefix=foo\noutput.mime=foo\n\nreports=icmp\n\nreport.icmp.name=ICMP\nreport.icmp.columns=icmp\nreport.icmp.type=responseTime\nreport.icmp.command=--title=\"ICMP Response Time\" \\\n  --vertical-label=\"Seconds\" \\\n  DEF:rtMicro={rrd1}:icmp:AVERAGE \\\n  CDEF:rt=rtMicro,1000000,/ \\\n  LINE1:rt#0000ff:\"Response Time\" \\\n  GPRINT:rt:AVERAGE:\" Avg  \\: %8.2lf %s\" \\\n  GPRINT:rt:MIN:\"Min  \\\\: %8.2lf %s\" \\\n  GPRINT:rt:MAX:\"Max  \\\\: %8.2lf %s\\\\n\"";
    protected static final String s_baseIncludePrefab = "command.prefix=foo\noutput.mime=image/png\nreports=\ninclude.directory=snmp-graph.properties.d\ninclude.directory.rescan=1000\n";
    protected static final String s_separateBitsGraph = "report.id=mib2.bits\nreport.name=Bits In/Out\nreport.columns=ifInOctets,ifOutOctets\nreport.type=interface\nreport.externalValues=ifSpeed\nreport.command=--title=\"Bits In/Out\"\n";
    protected static final String s_separateHCBitsGraph = "report.id=mib2.HCbits\nreport.name=Bits In/Out\nreport.columns=ifHCInOctets,ifHCOutOctets\nreport.type=interface\nreport.externalValues=ifSpeed\nreport.suppress=mib2.bits\nreport.command=--title=\"Bits In/Out (High Speed)\"\n";
    protected static final String s_separateErrorsGraph = "report.id=mib2.errors\nreport.name=Errors In/Out\nreport.columns=ifIfErrors,ifOutErrors\nreport.type=interface\nreport.propertiesValues=ifSpeed\nreport.command=--title=\"Erros In/Out\"\n";
    protected static final String s_includedMultiGraph1 = "reports=mib2.discards,mib2.errors\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\"\n\nreport.mib2.errors.name=Errors In/Out\nreport.mib2.errors.columns=ifInErrors,ifOutErrors\nreport.mib2.errors.type=interface\nreport.mib2.errors.propertiesValues=ifSpeed\nreport.mib2.errors.command=--title=\"Discards In/Out\"\n";
    protected static final String s_includedMultiGraph2 = "reports=mib2.bits,mib2.HCbits\nreport.mib2.bits.name=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\"\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\"\n";
    protected static final String s_mib2bitsBasePrefab = "command.prefix=foo\noutput.mime=image/png\ninclude.directory=snmp-graph.properties.d\nreports=mib2.bits\nreport.mib2.bits.name=Wrong Name\nreport.mib2.bits.columns=wrongColumn1,wrongColumn2\nreport.mib2.bits.type=node\nreport.mib2.bits.externalValues=fooBar\nreport.mib2.bits.command=--title=\"Wrong Title\"\n";
    protected static final String s_partlyBorkedPrefab = "command.prefix=foo\noutput.mime=foo\n\nreports=mib2.HCbits, mib2.bits, mib2.discards\n\nreport.mib2.HCbits.name=Bits In/Out\nreport.mib2.HCbits.columns=ifHCInOctets,ifHCOutOctets\nreport.mib2.HCbits.type=interface\nreport.mib2.HCbits.externalValues=ifSpeed\nreport.mib2.HCbits.suppress=mib2.bits\nreport.mib2.HCbits.command=--title=\"Bits In/Out (High Speed)\" \n\nreport.mib2.bits.nmae=Bits In/Out\nreport.mib2.bits.columns=ifInOctets,ifOutOctets\nreport.mib2.bits.type=interface\nreport.mib2.bits.externalValues=ifSpeed\nreport.mib2.bits.command=--title=\"Bits In/Out\" \n\nreport.mib2.discards.name=Discards In/Out\nreport.mib2.discards.columns=ifInDiscards,ifOutDiscards\nreport.mib2.discards.type=interface\nreport.mib2.discards.propertiesValues=ifSpeed\nreport.mib2.discards.command=--title=\"Discards In/Out\" \n";
    protected Map<String, FileReloadContainer<PrefabGraph>> m_graphs;
    protected PropertiesGraphDao m_dao;
    protected boolean m_testSpecificLoggingTest = false;
    protected FileAnticipator m_fileAnticipator = null;
    protected FileOutputStream m_outputStream = null;
    protected Writer m_writer = null;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true);
        this.m_dao = this.createPropertiesGraphDao(s_emptyMap, s_emptyMap);
        ByteArrayInputStream in = new ByteArrayInputStream(s_prefab.getBytes());
        this.m_dao.loadProperties("performance", (InputStream)in);
        PropertiesGraphDao.PrefabGraphTypeDao type = this.m_dao.findPrefabGraphTypeDaoByName("performance");
        Assert.assertNotNull((String)"could not get performance prefab graph type", (Object)type);
        this.m_graphs = type.getReportMap();
        Assert.assertNotNull((String)"report map shouldn't be null", this.m_graphs);
        this.m_fileAnticipator = new FileAnticipator();
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.closeQuietly((Writer)this.m_writer);
        IOUtils.closeQuietly((OutputStream)this.m_outputStream);
        this.m_writer = null;
        this.m_outputStream = null;
        System.gc();
        if (!this.m_testSpecificLoggingTest) {
            MockLogAppender.assertNoWarningsOrGreater();
        }
        this.m_fileAnticipator.deleteExpected();
        this.m_fileAnticipator.tearDown();
        MockLogAppender.resetEvents();
    }

    public PropertiesGraphDao createPropertiesGraphDao(Map<String, Resource> prefabConfigs, Map<String, Resource> adhocConfigs) throws IOException {
        PropertiesGraphDao dao = new PropertiesGraphDao();
        dao.setPrefabConfigs(prefabConfigs);
        dao.setAdhocConfigs(adhocConfigs);
        dao.afterPropertiesSet();
        return dao;
    }
}

