/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.CollectdConfigFactory;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DistributedStatusResourceType;
import org.opennms.netmgt.dao.support.DomainResourceType;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.InterfaceSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeSourceResourceType;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class DefaultResourceDao
implements ResourceDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceDao.class);
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
    private static final int MAXIMUM_NODE_METRIC_RESOURCE_DEPTH = 2;
    private ResourceStorageDao m_resourceStorageDao;
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private CollectdConfigFactory m_collectdConfig;
    private DataCollectionConfigDao m_dataCollectionConfigDao;
    private Date m_lastUpdateDataCollectionConfig;
    private Map<String, OnmsResourceType> m_resourceTypes = Maps.newHashMap();
    private NodeResourceType m_nodeResourceType;
    private NodeSourceResourceType m_nodeSourceResourceType;

    public DataCollectionConfigDao getDataCollectionConfigDao() {
        return this.m_dataCollectionConfigDao;
    }

    public void setDataCollectionConfigDao(DataCollectionConfigDao dataCollectionConfigDao) {
        this.m_dataCollectionConfigDao = dataCollectionConfigDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfig) {
        this.m_collectdConfig = collectdConfig;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
        if (this.m_resourceTypes.size() > 0) {
            this.initResourceTypes();
        }
    }

    public ResourceStorageDao getResourceStorageDao() {
        return this.m_resourceStorageDao;
    }

    public void afterPropertiesSet() {
        if (this.m_collectdConfig == null) {
            throw new IllegalStateException("collectdConfig property has not been set");
        }
        if (this.m_dataCollectionConfigDao == null) {
            throw new IllegalStateException("dataCollectionConfig property has not been set");
        }
        if (this.m_nodeDao == null) {
            throw new IllegalStateException("nodeDao property has not been set");
        }
        if (this.m_locationMonitorDao == null) {
            throw new IllegalStateException("locationMonitorDao property has not been set");
        }
        if (this.m_resourceStorageDao == null) {
            throw new IllegalStateException("resourceStorageDao property has not been set");
        }
        this.initResourceTypes();
    }

    private void initResourceTypes() {
        LinkedHashMap resourceTypes = Maps.newLinkedHashMap();
        Object resourceType = new NodeSnmpResourceType(this.m_resourceStorageDao);
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceType = new InterfaceSnmpResourceType(this.m_resourceStorageDao);
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceType = new ResponseTimeResourceType(this.m_resourceStorageDao, this.m_ipInterfaceDao);
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceType = new DistributedStatusResourceType(this.m_resourceStorageDao, this.m_locationMonitorDao);
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceTypes.putAll(GenericIndexResourceType.createTypes(this.m_dataCollectionConfigDao.getConfiguredResourceTypes(), this.m_resourceStorageDao));
        this.m_nodeResourceType = new NodeResourceType(this, this.m_nodeDao);
        resourceTypes.put(this.m_nodeResourceType.getName(), this.m_nodeResourceType);
        if (this.isDomainResourceTypeUsed()) {
            LOG.debug("One or more packages are configured with storeByIfAlias=true. Enabling the domain resource type.");
            resourceType = new DomainResourceType(this, this.m_resourceStorageDao);
            resourceTypes.put(resourceType.getName(), resourceType);
        } else {
            LOG.debug("No packages are configured with storeByIfAlias=true. Excluding the domain resource type.");
        }
        this.m_nodeSourceResourceType = new NodeSourceResourceType(this, this.m_nodeDao);
        resourceTypes.put(this.m_nodeSourceResourceType.getName(), this.m_nodeSourceResourceType);
        this.m_resourceTypes = resourceTypes;
        this.m_lastUpdateDataCollectionConfig = this.m_dataCollectionConfigDao.getLastUpdate();
    }

    public Collection<OnmsResourceType> getResourceTypes() {
        if (this.isDataCollectionConfigChanged()) {
            LOG.debug("The data collection configuration has been changed, reloading resource types.");
            this.initResourceTypes();
        }
        return this.m_resourceTypes.values();
    }

    @Transactional(readOnly=true)
    public List<OnmsResource> findTopLevelResources() {
        List<OnmsResource> resources = this.m_resourceTypes.values().stream().map(type -> type.getResourcesForParent(null)).flatMap(rs -> rs.stream()).collect(Collectors.toList());
        resources.addAll(this.findNodeResources());
        return resources;
    }

    protected List<OnmsResource> findNodeResources() {
        return this.m_nodeDao.findAll().stream().filter(node -> node.getType() == null || !node.getType().equals((Object)"D")).map(node -> this.getResourceForNode((OnmsNode)node)).filter(resource -> this.hasAnyChildResources((OnmsResource)resource)).collect(Collectors.toList());
    }

    protected boolean hasAnyChildResources(OnmsResource resource) {
        return this.getResourceTypes().stream().anyMatch(t -> t.isResourceTypeOnParent(resource));
    }

    @Transactional(readOnly=true)
    public OnmsResource getResourceById(String id) {
        OnmsResource resource = null;
        Matcher m = RESOURCE_ID_PATTERN.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String resourceTypeName = DefaultResourceDao.decode(m.group(1));
            String resourceName = DefaultResourceDao.decode(m.group(2));
            try {
                resource = this.getChildResource(resource, resourceTypeName, resourceName);
            }
            catch (Throwable e) {
                LOG.warn("Could not get resource for resource ID \"{}\"", (Object)id, (Object)e);
                return null;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            LOG.warn("Resource ID '{}' does not match pattern '{}' at '{}'", new Object[]{id, RESOURCE_ID_PATTERN, sb});
            return null;
        }
        return resource;
    }

    public OnmsResource getResourceForNode(OnmsNode node) {
        boolean nodeSourcePathExists;
        Assert.notNull((Object)node, (String)"node argument must not be null");
        boolean createUsingNodeSourceType = ResourceTypeUtils.isStoreByForeignSource();
        if (createUsingNodeSourceType && (node.getForeignSource() == null || node.getForeignId() == null)) {
            createUsingNodeSourceType = false;
        }
        if (createUsingNodeSourceType && !(nodeSourcePathExists = this.m_resourceStorageDao.existsWithin(NodeSourceResourceType.getResourcePathForNode(node), 2))) {
            boolean nodePathExists = this.m_resourceStorageDao.existsWithin(NodeResourceType.getResourcePathForNode(node), 2);
            boolean bl = createUsingNodeSourceType = !nodePathExists;
        }
        if (createUsingNodeSourceType) {
            return this.m_nodeSourceResourceType.createResourceForNode(node);
        }
        return this.m_nodeResourceType.createResourceForNode(node);
    }

    public OnmsResource getResourceForIpInterface(OnmsIpInterface ipInterface, OnmsLocationMonitor locMon) {
        Assert.notNull((Object)ipInterface, (String)"ipInterface argument must not be null");
        Assert.notNull((Object)locMon, (String)"locMon argument must not be null");
        Assert.notNull((Object)ipInterface.getNode(), (String)"getNode() on ipInterface must not return null");
        String ipAddress = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
        OnmsResource nodeResource = this.getResourceForNode(ipInterface.getNode());
        return this.getChildResource(nodeResource, "distributedStatus", DistributedStatusResourceType.getResourceName(locMon.getId(), ipAddress));
    }

    public boolean deleteResourceById(String resourceId) {
        OnmsResource resource = this.getResourceById(resourceId);
        if (resource == null) {
            return false;
        }
        return this.deleteResource(resource, true);
    }

    public boolean deleteResource(OnmsResource resource, boolean recursive) {
        boolean result = false;
        if (recursive) {
            for (OnmsResource childResource : resource.getChildResources()) {
                result = this.deleteResource(childResource, recursive) || result;
            }
        }
        result = this.m_resourceStorageDao.delete(resource.getPath()) || result;
        return result;
    }

    protected OnmsResource getChildResource(OnmsResource parentResource, String resourceType, String resource) {
        OnmsResourceType targetType = this.m_resourceTypes.get(resourceType);
        if (targetType == null) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Unsupported resource type: " + resourceType, null);
        }
        OnmsResource childResource = targetType.getChildByName(parentResource, resource);
        if (childResource != null) {
            LOG.debug("getChildResource: returning resource {}", (Object)childResource);
            return childResource;
        }
        throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Could not find child resource '" + resource + "' with resource type '" + resourceType + "' on resource '" + resource + "'", null);
    }

    private boolean isDataCollectionConfigChanged() {
        Date current = this.m_dataCollectionConfigDao.getLastUpdate();
        if (current.after(this.m_lastUpdateDataCollectionConfig)) {
            this.m_lastUpdateDataCollectionConfig = current;
            return true;
        }
        return false;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isDomainResourceTypeUsed() {
        for (Package pkg : this.m_collectdConfig.getCollectdConfig().getPackages()) {
            if (!"true".equalsIgnoreCase(pkg.getStoreByIfAlias())) continue;
            return true;
        }
        return false;
    }
}

