/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.opennms.netmgt.dao.support.DefaultRrdDao;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.FileAnticipator;

public class DefaultRrdDaoIntegrationTest
extends TestCase {
    private FileAnticipator m_fileAnticipator;
    private RrdStrategy<RrdDef, RrdDb> m_rrdStrategy;
    private DefaultRrdDao m_dao;

    public void setUp() throws Exception {
        super.setUp();
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_dao = new DefaultRrdDao();
        this.m_dao.setRrdStrategy(this.m_rrdStrategy);
        this.m_dao.setRrdBaseDirectory(this.m_fileAnticipator.getTempDir());
        this.m_dao.setRrdBinaryPath("/bin/true");
        this.m_dao.afterPropertiesSet();
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
        super.tearDown();
    }

    public void testInit() {
    }

    public void testPrintValue() throws Exception {
        long start = System.currentTimeMillis();
        long end = start + 86400000L;
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0), new ResourcePath(new String[]{"foo"}));
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", "snmp/1/eth0", "ifInOctets.jrb");
        HashSet<RrdGraphAttribute> attributeSet = new HashSet<RrdGraphAttribute>(1);
        attributeSet.add(attribute);
        MockResourceType childResourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface One: eth0", (OnmsResourceType)childResourceType, attributeSet, new ResourcePath(new String[]{"foo"}));
        childResource.setParent(topResource);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File node = this.m_fileAnticipator.tempDir(snmp, topResource.getName());
        File intf = this.m_fileAnticipator.tempDir(node, childResource.getName());
        RrdDataSource rrdDataSource = new RrdDataSource(attribute.getName(), "GAUGE", 600, "U", "U");
        RrdDef def = (RrdDef)this.m_rrdStrategy.createDefinition("test", intf.getAbsolutePath(), attribute.getName(), 600, Collections.singletonList(rrdDataSource), Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        this.m_rrdStrategy.createFile((Object)def);
        File rrdFile = this.m_fileAnticipator.expecting(intf, attribute.getName() + this.m_rrdStrategy.getDefaultFileExtension());
        RrdDb rrdFileObject = (RrdDb)this.m_rrdStrategy.openFile(rrdFile.getAbsolutePath());
        for (int i = 0; i < 10; ++i) {
            this.m_rrdStrategy.updateFile((Object)rrdFileObject, "test", start / 1000L + (long)(300 * i) + ":1");
        }
        this.m_rrdStrategy.closeFile((Object)rrdFileObject);
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        DefaultRrdDaoIntegrationTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoIntegrationTest.assertEquals((String)"value", (Object)1.0, (Object)value);
    }

    public void testNMS4861() throws Exception {
        long endTime = 1312839213L;
        long startTime = endTime - 86400L;
        String command = "/sw/bin/rrdtool graph - --imgformat PNG --font DEFAULT:7 --font TITLE:10 --start " + startTime + " --end " + endTime + " --title=\"Netscreen Memory Utilization\" --units-exponent=0  --lower-limit=0 DEF:value1=netscreen-host-resources.jrb:NetScrnMemAlloc:AVERAGE DEF:value1min=netscreen-host-resources.jrb:NetScrnMemAlloc:MIN DEF:value1max=netscreen-host-resources.jrb:NetScrnMemAlloc:MAX DEF:value2=netscreen-host-resources.jrb:NetScrnMemLeft:AVERAGE DEF:value2min=netscreen-host-resources.jrb:NetScrnMemLeft:MIN DEF:value2max=netscreen-host-resources.jrb:NetScrnMemLeft:MAX DEF:value3=netscreen-host-resources.jrb:NetScrnMemFrag:AVERAGE DEF:value3min=netscreen-host-resources.jrb:NetScrnMemFrag:MIN DEF:value3max=netscreen-host-resources.jrb:NetScrnMemFrag:MAX LINE2:value1#0000ff:\"1  minute\" GPRINT:value1:AVERAGE:\"Avg \\: %10.2lf\" GPRINT:value1:MIN:\"Min \\: %10.2lf\" GPRINT:value1:MAX:\"Max \\: %10.2lf\\n\" LINE2:value2#00ff00:\"5  minute\" GPRINT:value2:AVERAGE:\"Avg \\: %10.2lf\" GPRINT:value2:MIN:\"Min \\: %10.2lf\" GPRINT:value2:MAX:\"Max \\: %10.2lf\\n\" LINE2:value3#ff0000:\"15 minute\" GPRINT:value3:AVERAGE:\"Avg \\: %10.2lf\" GPRINT:value3:MIN:\"Min \\: %10.2lf\" GPRINT:value3:MAX:\"Max \\: %10.2lf\\n\"";
        File workDir = new File("src/test/resources");
        RrdGraphDetails details = this.m_rrdStrategy.createGraphReturnDetails(command, workDir);
        File outputFile = File.createTempFile("img", "png");
        IOUtils.copy((InputStream)details.getInputStream(), (OutputStream)new FileOutputStream(outputFile));
    }
}

