/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.dao.support.ResourceTreeWalker;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceVisitor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class ResourceDaoIntegrityIT
implements InitializingBean {
    private EasyMockUtils m_easyMockUtils;
    private FilterDao m_filterDao;
    private CollectdConfigFactory m_collectdConfig;
    private ResourceTypesDao m_resourceTypesDao;
    private DefaultResourceDao m_resourceDao;
    private FilesystemResourceStorageDao m_resourceStorageDao = new FilesystemResourceStorageDao();
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private LocationMonitorDao m_locationMonitorDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Rule
    public TemporaryFolder m_tempFolder = new TemporaryFolder();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.setStoreByForeignSource(false);
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_resourceTypesDao = (ResourceTypesDao)this.m_easyMockUtils.createMock(ResourceTypesDao.class);
        this.m_filterDao = (FilterDao)this.m_easyMockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList("IPADDR IPLIKE *.*.*.*")).andReturn(new ArrayList(0)).anyTimes();
        this.m_easyMockUtils.replayAll();
        InputStream stream = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/collectdconfiguration-testdata.xml");
        this.m_collectdConfig = new CollectdConfigFactory(stream, "localhost", false);
        this.m_easyMockUtils.verifyAll();
        this.m_resourceStorageDao.setRrdDirectory(this.m_tempFolder.getRoot());
        this.m_resourceStorageDao.setRrdExtension(".rrd");
        this.m_resourceDao = new DefaultResourceDao();
        this.m_resourceDao.setNodeDao(this.m_nodeDao);
        this.m_resourceDao.setLocationMonitorDao(this.m_locationMonitorDao);
        this.m_resourceDao.setCollectdConfig((org.opennms.netmgt.config.api.CollectdConfigFactory)this.m_collectdConfig);
        this.m_resourceDao.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        this.m_resourceDao.setResourceTypesDao(this.m_resourceTypesDao);
        this.m_resourceDao.setIpInterfaceDao(this.m_ipInterfaceDao);
    }

    @Test
    @Transactional
    public void walkResourceTree() throws IOException {
        this.createResourceTree();
        this.createNodes();
        Map<String, ResourceType> types = this.createResourceTypes();
        EasyMock.expect((Object)this.m_resourceTypesDao.getLastUpdate()).andReturn((Object)new Date(System.currentTimeMillis())).anyTimes();
        EasyMock.expect((Object)this.m_resourceTypesDao.getResourceTypes()).andReturn(types).anyTimes();
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        ResourceCollector visitor = new ResourceCollector();
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao((ResourceDao)this.m_resourceDao);
        walker.setVisitor((ResourceVisitor)visitor);
        walker.walk();
        for (OnmsResourceType onmsResourceType : this.m_resourceDao.getResourceTypes()) {
            if (onmsResourceType.getName() == "distributedStatus") continue;
            Assert.assertTrue((String)("No resources of type: " + onmsResourceType.getLabel()), (boolean)visitor.resourceTypes.contains(onmsResourceType));
        }
        for (Map.Entry entry : visitor.resourcesById.entrySet()) {
            OnmsResource resourceRetrievedById = this.m_resourceDao.getResourceById((String)entry.getKey());
            Assert.assertNotNull((String)String.format("Failed to retrieve resource with id '%s'.", entry.getKey()), (Object)resourceRetrievedById);
            Assert.assertEquals((String)String.format("Result mismatch for resource with id '%s'. Retrieved id is '%s'.", entry.getKey(), resourceRetrievedById.getId()), (Object)((OnmsResource)entry.getValue()).getName(), (Object)resourceRetrievedById.getName());
        }
        int k = 0;
        String[] stringArray = this.loadExpectedResults();
        for (Map.Entry entry : visitor.resourcesById.entrySet()) {
            TreeSet<String> attributeNames = new TreeSet<String>();
            for (OnmsAttribute attribute : ((OnmsResource)entry.getValue()).getAttributes()) {
                attributeNames.add(attribute.toString());
            }
            String actualResult = (String)entry.getKey() + ": " + attributeNames;
            Assert.assertEquals((String)String.format("Result mismatch at line %d.", k + 1), (Object)stringArray[k], (Object)actualResult);
            ++k;
        }
        Assert.assertEquals((long)stringArray.length, (long)visitor.resourcesById.size());
        this.m_easyMockUtils.verifyAll();
    }

    private String[] loadExpectedResults() throws IOException {
        String fileAsString = IOUtils.toString((InputStream)new ClassPathResource("resource-tree-results.txt").getInputStream());
        return fileAsString.split("\\r?\\n");
    }

    private void createResourceTree() throws IOException {
        String fileAsString = IOUtils.toString((InputStream)new ClassPathResource("resource-tree-files.txt").getInputStream());
        String[] resourceTreeFiles = fileAsString.split("\\r?\\n");
        Assert.assertEquals((long)31829L, (long)resourceTreeFiles.length);
        for (String resourceTreeFile : resourceTreeFiles) {
            File entry = new File(this.m_tempFolder.getRoot(), resourceTreeFile);
            entry.getParentFile().mkdirs();
            Assert.assertTrue((String)("Failed to create " + entry), (boolean)entry.createNewFile());
        }
    }

    private void createNodes() throws IOException {
        int NUM_NODES = 250;
        String fileAsString = IOUtils.toString((InputStream)new ClassPathResource("resource-tree-ips.txt").getInputStream());
        String[] resourceTreeIps = fileAsString.split("\\r?\\n");
        Assert.assertTrue((resourceTreeIps.length < 250 ? 1 : 0) != 0);
        for (int i = 1; i <= 250; ++i) {
            OnmsNode node = new OnmsNode();
            node.setLabel("node" + i);
            node.setForeignSource("NODES");
            node.setForeignId(Integer.toString(i));
            this.m_nodeDao.save((Object)node);
            OnmsIpInterface intf = new OnmsIpInterface();
            intf.setIpAddress(InetAddressUtils.addr((String)resourceTreeIps[i % resourceTreeIps.length]));
            intf.setNode(node);
            this.m_ipInterfaceDao.save((Object)intf);
            node.setIpInterfaces(Collections.singleton(intf));
            this.m_nodeDao.saveOrUpdate((Object)node);
        }
    }

    private Map<String, ResourceType> createResourceTypes() {
        HashMap<String, ResourceType> types = new HashMap<String, ResourceType>();
        ResourceType hrStorageIndex = new ResourceType();
        hrStorageIndex.setName("hrStorageIndex");
        hrStorageIndex.setLabel("Storage (SNMP MIB-2 Host Resources)");
        hrStorageIndex.setResourceLabel("${hrStorageDescr}");
        hrStorageIndex.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy("org.opennms.netmgt.collectd.PersistAllSelectorStrategy"));
        StorageStrategy storageStrategy = new StorageStrategy("org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy");
        storageStrategy.addParameter(new Parameter("sibling-column-name", "hrStorageDescr"));
        storageStrategy.addParameter(new Parameter("replace-first", "s/^-$/_root_fs/"));
        storageStrategy.addParameter(new Parameter("replace-all", "s/^-//"));
        storageStrategy.addParameter(new Parameter("replace-all", "s/\\s//"));
        storageStrategy.addParameter(new Parameter("replace-all", "s/:\\\\.*//"));
        hrStorageIndex.setStorageStrategy(storageStrategy);
        types.put(hrStorageIndex.getName(), hrStorageIndex);
        return types;
    }

    private void setStoreByForeignSource(boolean storeByForeignSource) {
        System.setProperty("org.opennms.rrd.storeByForeignSource", Boolean.toString(storeByForeignSource));
    }

    private static class ResourceCollector
    implements ResourceVisitor {
        private Map<String, OnmsResource> resourcesById = new TreeMap<String, OnmsResource>();
        private Set<OnmsResourceType> resourceTypes = new HashSet<OnmsResourceType>();

        private ResourceCollector() {
        }

        public void visit(OnmsResource resource) {
            resource.getResourceType();
            this.resourcesById.put(resource.getId(), resource);
            this.resourceTypes.add(resource.getResourceType());
        }
    }
}

