/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.NullRrdStrategy;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class GenericIndexResourceTypeTest {
    private static final String RRD_FILE_NAME = "ds.nullRrd";
    private FileAnticipator m_fileAnticipator;
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private StorageStrategy m_storageStrategy = (StorageStrategy)this.m_mocks.createMock(StorageStrategy.class);
    private NodeDao m_nodeDao = (NodeDao)this.m_mocks.createMock(NodeDao.class);
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);

    @Before
    public void setUp() throws IOException {
        this.m_fileAnticipator = new FileAnticipator();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        this.m_resourceStorageDao.setRrdStrategy((RrdStrategy)new NullRrdStrategy());
    }

    @After
    public void tearDown() {
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
        this.m_fileAnticipator.tearDown();
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelPlain() throws IOException {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "plain", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"plain", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndex() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${index}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"1", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelStringAttribute() throws Exception {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${stringAttribute}", this.m_storageStrategy);
        File rrd = this.touch("snmp", "1", "foo", "1", RRD_FILE_NAME);
        this.m_fileAnticipator.tempFile(rrd.getParentFile(), "strings.properties", "stringAttribute=hello!!!!");
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"hello!!!!", (Object)resource.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResourceByNodeSourceAndIndexGetLabelStringAttribute() throws IOException {
        try {
            System.setProperty("org.opennms.rrd.storeByForeignSource", "true");
            GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${stringAttribute}", this.m_storageStrategy);
            File rrd = this.touch("snmp", "fs", "source1", "123", "foo", "1", RRD_FILE_NAME);
            this.m_fileAnticipator.tempFile(rrd.getParentFile(), "strings.properties", "stringAttribute=hello!!!!");
            this.m_mocks.replayAll();
            OnmsResource resource = rt.getChildByName(this.getNodeResource("source1", "123"), "1");
            this.m_mocks.verifyAll();
            Assert.assertNotNull((String)"resource", (Object)resource);
            Assert.assertEquals((String)"resource label", (Object)"hello!!!!", (Object)resource.getLabel());
        }
        finally {
            System.setProperty("org.opennms.rrd.storeByForeignSource", "false");
        }
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexNumber() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(3, 1)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"4", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBogusArguments() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(absolutely bogus)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex(absolutely bogus)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBogusOffset() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(foo, 1)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex(foo, 1)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBadNumber() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(4, 1)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex(4, 1)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBeginning() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(1)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"2.3.4", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexEnding() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(0, 3)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"1.2.3", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexNoArguments() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex()}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex()}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexStartOutOfBounds() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(4)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex(4)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexEndOutOfBounds() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${subIndex(0, 5)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${subIndex(0, 5)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithHexConversion() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${hex(index)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.2.3.4.14.15", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.2.3.4.14.15");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"01:02:03:04:0E:0F", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithHexConversionBogusInteger() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "${hex(index)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "foo", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "foo");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"${hex(index)}", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndHexConversion() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "MAC Address ${hex(subIndex(0, 6))} on interface ${subIndex(6, 1)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "0.21.109.80.9.66.4", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "0.21.109.80.9.66.4");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"MAC Address 00:15:6D:50:09:42 on interface 4", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${subIndex(0, n)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "5.1.2.3.4.5", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "5.1.2.3.4.5");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as 1.2.3.4.5", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithThreeSubStringsOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${subIndex(0, n)} and ${subIndex(n, n)} and ${subIndex(n, n)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.1.2.1.2.3.1.2.3", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.1.2.1.2.3.1.2.3");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as 1 and 1.2 and 1.2.3", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndDynSubStringAndDynSubStringAndSubStringToEnd() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${subIndex(0, 1)} and ${subIndex(1, n)} and ${subIndex(n, n)} and ${subIndex(n)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "3.3.1.2.3.3.4.5.6.0", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "3.3.1.2.3.3.4.5.6.0");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as 3 and 1.2.3 and 4.5.6 and 0", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithDisplaySubStringOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${string(subIndex(0, n))}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "3.112.105.101", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "3.112.105.101");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as pie", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndTwoDisplaySubStringsOfDynamicLengthAndSubStringToEnd() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${subIndex(0, 1)} piece of ${string(subIndex(1, n))} or just under ${string(subIndex(n, n))} pieces of ${subIndex(n)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "1.3.112.105.101.2.80.105.3.1.4.1.5.9", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "1.3.112.105.101.2.80.105.3.1.4.1.5.9");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as 1 piece of pie or just under Pi pieces of 3.1.4.1.5.9", (Object)resource.getLabel());
    }

    @Test
    public void testGetResourceByNodeAndIndexGetLabelIndexWithBogusUseOfNforStartOfFirstSubIndex() {
        GenericIndexResourceType rt = new GenericIndexResourceType((ResourceStorageDao)this.m_resourceStorageDao, "foo", "Foo Resource", "Easy as ${subIndex(n, 3)}", this.m_storageStrategy);
        this.touch("snmp", "1", "foo", "3.1.2.3", RRD_FILE_NAME);
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getChildByName(this.getNodeResource(1), "3.1.2.3");
        this.m_mocks.verifyAll();
        Assert.assertNotNull((String)"resource", (Object)resource);
        Assert.assertEquals((String)"resource label", (Object)"Easy as ${subIndex(n, 3)}", (Object)resource.getLabel());
    }

    private OnmsResource getNodeResource(int nodeId) {
        NodeResourceType nodeResourceType = new NodeResourceType(this.m_resourceDao, this.m_nodeDao);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        node.setLabel("Node" + nodeId);
        return nodeResourceType.createResourceForNode(node);
    }

    private OnmsResource getNodeResource(String fs, String fid) {
        NodeResourceType nodeSourceResourceType = new NodeResourceType(this.m_resourceDao, this.m_nodeDao);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(0));
        node.setLabel("Node");
        node.setForeignSource(fs);
        node.setForeignId(fid);
        return nodeSourceResourceType.createResourceForNode(node);
    }

    private File touch(String first, String ... more) {
        Path parent = this.m_fileAnticipator.getTempDir().toPath();
        Path path = parent.resolve(Paths.get(first, more));
        File file = path.toFile();
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Assert.assertTrue((boolean)file.canRead());
        return file;
    }
}

