/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.UpsertService;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultUpsertService
implements UpsertService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUpsertService.class);
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    PlatformTransactionManager m_transactionManager;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    public OnmsSnmpInterface upsert(final int nodeId, final OnmsSnmpInterface snmpInterface, final int sleep) {
        UpsertTemplate<OnmsSnmpInterface, SnmpInterfaceDao> upzerter = new UpsertTemplate<OnmsSnmpInterface, SnmpInterfaceDao>(this.m_transactionManager, this.m_snmpInterfaceDao){

            public OnmsSnmpInterface query() {
                OnmsSnmpInterface dbSnmpIface = DefaultUpsertService.this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), snmpInterface.getIfIndex());
                DefaultUpsertService.this.sleep(sleep);
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doUpdate(OnmsSnmpInterface dbSnmpIface) {
                LOG.debug("nodeId = {}, ifIndex = {}, dbSnmpIface = {}", new Object[]{nodeId, snmpInterface.getIfIndex(), dbSnmpIface});
                dbSnmpIface.mergeSnmpInterfaceAttributes(snmpInterface);
                LOG.info("Updating SnmpInterface {}", (Object)dbSnmpIface);
                DefaultUpsertService.this.m_snmpInterfaceDao.update((Object)dbSnmpIface);
                DefaultUpsertService.this.m_snmpInterfaceDao.flush();
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doInsert() {
                OnmsNode dbNode = (OnmsNode)DefaultUpsertService.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                snmpInterface.setNode(dbNode);
                LOG.info("Saving SnmpInterface {}", (Object)snmpInterface);
                DefaultUpsertService.this.m_snmpInterfaceDao.save((Object)snmpInterface);
                DefaultUpsertService.this.m_snmpInterfaceDao.flush();
                return snmpInterface;
            }
        };
        return (OnmsSnmpInterface)upzerter.execute();
    }

    public void sleep(int sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

