/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsPathOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class PathOutageDaoIT
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private PathOutageDao m_pathOutageDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    TransactionTemplate m_transTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                OnmsServiceType t = new OnmsServiceType("ICMP");
                PathOutageDaoIT.this.m_serviceTypeDao.save((Object)t);
            }
        });
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName("ICMP");
        Assert.assertNotNull((Object)serviceType);
        OnmsNode router = new OnmsNode("router");
        this.m_nodeDao.save((Object)router);
        OnmsIpInterface routerIpInterface = new OnmsIpInterface(InetAddressUtils.addr((String)"172.16.1.1"), router);
        routerIpInterface.setIsManaged("M");
        OnmsMonitoredService routerService = new OnmsMonitoredService(routerIpInterface, serviceType);
        routerService.setStatus("A");
        OnmsNode node = new OnmsNode("localhost");
        this.m_nodeDao.save((Object)node);
        OnmsIpInterface nodeIpInterface = new OnmsIpInterface(InetAddressUtils.addr((String)"172.16.1.2"), node);
        nodeIpInterface.setIsManaged("M");
        OnmsMonitoredService nodeMonitoredService = new OnmsMonitoredService(nodeIpInterface, serviceType);
        nodeMonitoredService.setStatus("A");
        OnmsNode newNode = new OnmsNode("newnode");
        this.m_nodeDao.save((Object)newNode);
        OnmsIpInterface newIpInterface = new OnmsIpInterface(InetAddressUtils.addr((String)"172.16.1.3"), newNode);
        newIpInterface.setIsManaged("D");
        OnmsMonitoredService newMonitoredService = new OnmsMonitoredService(newIpInterface, serviceType);
        newMonitoredService.setStatus("A");
        OnmsPathOutage outage = new OnmsPathOutage(node, routerIpInterface.getIpAddress(), routerService.getServiceName());
        this.m_pathOutageDao.save((Object)outage);
        OnmsPathOutage temp = (OnmsPathOutage)this.m_pathOutageDao.get((Serializable)outage.getNode().getId());
        Assert.assertEquals((long)1L, (long)this.m_pathOutageDao.countAll());
        Assert.assertEquals((Object)node.getLabel(), (Object)temp.getNode().getLabel());
        Assert.assertEquals((Object)routerIpInterface.getIpAddress(), (Object)temp.getCriticalPathIp());
        Assert.assertEquals((Object)routerService.getServiceName(), (Object)temp.getCriticalPathServiceName());
        List nodes = this.m_pathOutageDao.getNodesForPathOutage(temp);
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)node.getId(), nodes.get(0));
        nodes = this.m_pathOutageDao.getNodesForPathOutage(routerIpInterface.getIpAddress(), routerService.getServiceName());
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)node.getId(), nodes.get(0));
        nodes = this.m_pathOutageDao.getNodesForPathOutage(nodeIpInterface.getIpAddress(), nodeMonitoredService.getServiceName());
        Assert.assertEquals((long)0L, (long)nodes.size());
        nodes = this.m_pathOutageDao.getNodesForPathOutage(newIpInterface.getIpAddress(), newMonitoredService.getServiceName());
        Assert.assertEquals((long)0L, (long)nodes.size());
        Assert.assertEquals((long)1L, (long)this.m_pathOutageDao.countAll());
        OnmsPathOutage newOutage = new OnmsPathOutage(newNode, routerIpInterface.getIpAddress(), routerService.getServiceName());
        this.m_pathOutageDao.save((Object)newOutage);
        Assert.assertEquals((long)2L, (long)this.m_pathOutageDao.countAll());
        nodes = this.m_pathOutageDao.getNodesForPathOutage(routerIpInterface.getIpAddress(), routerService.getServiceName());
        Assert.assertEquals((long)2L, (long)nodes.size());
        nodes = this.m_pathOutageDao.getAllNodesDependentOnAnyServiceOnInterface(routerIpInterface.getIpAddress());
        Assert.assertEquals((long)2L, (long)nodes.size());
        newIpInterface.setIsManaged("M");
        nodes = this.m_pathOutageDao.getNodesForPathOutage(routerIpInterface.getIpAddress(), routerService.getServiceName());
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(node.getId()));
        Assert.assertTrue((boolean)nodes.contains(newNode.getId()));
        Assert.assertEquals((long)2L, (long)this.m_pathOutageDao.countAll());
    }
}

