/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.users.Userinfo;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class CastorUtilsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testUnmarshalReader() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        CastorUtils.unmarshal(Userinfo.class, (InputStream)ConfigurationTestUtils.getInputStreamForConfigFile((String)"users.xml"));
    }

    public void testUnmarshalResource() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        CastorUtils.unmarshal(Userinfo.class, (Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"users.xml")));
    }

    public void testExceptionContainsFileNameUnmarshalResourceWithBadResource() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        boolean gotException = false;
        File file = ConfigurationTestUtils.getFileForConfigFile((String)"groups.xml");
        try {
            CastorUtils.unmarshal(Userinfo.class, (Resource)new FileSystemResource(file));
        }
        catch (MarshalException e) {
            String matchString = file.getAbsolutePath().replace('\\', '/');
            if (e.toString().contains(matchString)) {
                gotException = true;
            }
            AssertionFailedError ae = new AssertionFailedError("Got an exception, but not one containing the message we were expecting ('" + matchString + "'): " + (Object)((Object)e));
            ae.initCause((Throwable)e);
            throw ae;
        }
        if (!gotException) {
            CastorUtilsTest.fail((String)"Did not get a MarshalException, but we were expecting one.");
        }
    }

    public void testUnmarshalInputStreamQuietly() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        CastorUtils.unmarshal(Userinfo.class, (InputStream)ConfigurationTestUtils.getInputStreamForConfigFile((String)"users.xml"));
        MockLogAppender.assertNoLogging();
    }

    public void testUnmarshalReaderQuietly() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        CastorUtils.unmarshal(Userinfo.class, (InputStream)ConfigurationTestUtils.getInputStreamForConfigFile((String)"users.xml"));
        MockLogAppender.assertNoLogging();
    }

    public void testUnmarshallInputStreamWithUtf8() throws MarshalException, ValidationException, IOException {
        Userinfo users = (Userinfo)CastorUtils.unmarshal(Userinfo.class, (InputStream)ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/users-utf8.xml"));
        CastorUtilsTest.assertEquals((String)"user count", (int)1, (int)users.getUsers().getUserCount());
        CastorUtilsTest.assertEquals((String)"user name", (String)"Admi\u00f1istrator", (String)users.getUsers().getUser(0).getFullName());
    }

    public void testUnmarshallResourceWithUtf8() throws MarshalException, ValidationException, IOException {
        Userinfo users = (Userinfo)CastorUtils.unmarshal(Userinfo.class, (Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/users-utf8.xml")));
        CastorUtilsTest.assertEquals((String)"user count", (int)1, (int)users.getUsers().getUserCount());
        CastorUtilsTest.assertEquals((String)"user name", (String)"Admi\u00f1istrator", (String)users.getUsers().getUser(0).getFullName());
    }
}

