/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.api.DatabaseSchemaConfig;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.support.FilterWalker;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.JdbcFilterDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class JdbcFilterDaoIT
implements InitializingBean {
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    IpInterfaceDao m_interfaceDao;
    @Autowired
    ServiceTypeDao m_serviceTypeDao;
    JdbcFilterDao m_dao;
    @Autowired
    DatabasePopulator m_populator;
    @Autowired
    TransactionTemplate m_transTemplate;
    @Autowired
    DataSource m_dataSource;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        OnmsServiceType t = new OnmsServiceType("ICMP");
        this.m_serviceTypeDao.save((Object)t);
        this.m_populator.populateDatabase();
        System.setProperty("opennms.home", "src/test/resources");
        DatabaseSchemaConfigFactory.init();
        this.m_dao = new JdbcFilterDao();
        this.m_dao.setDataSource(this.m_dataSource);
        this.m_dao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)DatabaseSchemaConfigFactory.getInstance());
        this.m_dao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)this.m_dao);
    }

    @Test
    @Transactional
    public void testInstantiate() {
        new JdbcFilterDao();
    }

    @Test
    @Transactional
    public void testAfterPropertiesSetValid() throws Exception {
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.m_dataSource);
        InputStream is = ConfigurationTestUtils.getInputStreamForConfigFile((String)"database-schema.xml");
        dao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)new DatabaseSchemaConfigFactory(is));
        is.close();
        dao.afterPropertiesSet();
    }

    @Test
    @Transactional
    public void testAfterPropertiesSetNoNodeDao() throws Exception {
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.m_dataSource);
        InputStream is = ConfigurationTestUtils.getInputStreamForConfigFile((String)"database-schema.xml");
        dao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)new DatabaseSchemaConfigFactory(is));
        is.close();
        dao.afterPropertiesSet();
    }

    @Test
    @Transactional
    public void testAfterPropertiesSetNoDataSource() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        JdbcFilterDao dao = new JdbcFilterDao();
        InputStream is = ConfigurationTestUtils.getInputStreamForConfigFile((String)"database-schema.xml");
        dao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)new DatabaseSchemaConfigFactory(is));
        is.close();
        ta.anticipate((Throwable)new IllegalStateException("property dataSource cannot be null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testWithManyCatIncAndServiceIdentifiersInRules() throws Exception {
        String rule = String.format("(catincIMP_mid) & (catincDEV_AC) & (catincOPS_Online) & (nodeId == '%s') & (ipAddr == '192.168.1.1') & (serviceName == 'ICMP')", this.m_populator.getNode1().getId().toString());
        Assert.assertTrue((String)("Rule match failed: " + rule), (boolean)this.m_dao.isRuleMatching(rule));
        String rule2 = String.format("(catincIMP_mid) & (catincDEV_AC) & (catincOPS_Online) & (nodeId == '%s') & (ipAddr == '192.168.2.1') & (serviceName == 'ICMP')", this.m_populator.getNode2().getId().toString());
        Assert.assertFalse((String)("Rule match succeeded unexpectedly: " + rule), (boolean)this.m_dao.isRuleMatching(rule2));
    }

    @Test
    @Transactional
    public void testAfterPropertiesSetNoSchemaFactory() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        JdbcFilterDao dao = new JdbcFilterDao();
        dao.setDataSource(this.m_dataSource);
        ta.anticipate((Throwable)new IllegalStateException("property databaseSchemaConfigFactory cannot be null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @Transactional
    public void testGetNodeMap() throws Exception {
        SortedMap map = this.m_dao.getNodeMap("ipaddr == '1.1.1.1'");
        Assert.assertNotNull((String)"returned map should not be null", (Object)map);
        Assert.assertEquals((String)"map size", (long)0L, (long)map.size());
    }

    @Test
    @Transactional
    public void testGetIPAddressServiceMap() throws Exception {
        Map map = this.m_dao.getIPAddressServiceMap("ipaddr == '1.1.1.1'");
        Assert.assertNotNull((String)"returned map should not be null", (Object)map);
        Assert.assertEquals((String)"map size", (long)0L, (long)map.size());
    }

    @Test
    @Transactional
    public void testGetIPAddressList() throws Exception {
        List list = this.m_dao.getIPAddressList("ipaddr == '1.1.1.1'");
        Assert.assertNotNull((String)"returned list should not be null", (Object)list);
        Assert.assertEquals((String)"list size", (long)0L, (long)list.size());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetActiveIPListWithDeletedNode() throws Exception {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                List ifaces = JdbcFilterDaoIT.this.m_interfaceDao.findByIpAddress("192.168.1.1");
                Assert.assertEquals((String)"should be 1 interface", (long)1L, (long)ifaces.size());
                OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
                iface.setIsManaged("D");
                JdbcFilterDaoIT.this.m_interfaceDao.save((Object)iface);
                JdbcFilterDaoIT.this.m_interfaceDao.flush();
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                List list = JdbcFilterDaoIT.this.m_dao.getActiveIPAddressList("ipaddr == '192.168.1.1'");
                Assert.assertNotNull((String)"returned list should not be null", (Object)list);
                Assert.assertEquals((String)"no nodes should be returned, since the only one has been deleted", (long)0L, (long)list.size());
            }
        });
    }

    @Test
    @Transactional
    public void testIsValid() throws Exception {
        Assert.assertFalse((String)"There is nothing in the database, so isValid shouldn't match non-empty rules", (boolean)this.m_dao.isValid("1.1.1.1", "ipaddr == '1.1.1.1'"));
    }

    @Test
    @Transactional
    public void testIsValidEmptyRule() throws Exception {
        Assert.assertTrue((String)"isValid should return true for non-empty rules", (boolean)this.m_dao.isValid("1.1.1.1", ""));
    }

    @Test
    @Transactional
    public void testGetInterfaceWithServiceStatement() throws Exception {
        Assert.assertEquals((String)"SQL from getInterfaceWithServiceStatement", (Object)"SELECT DISTINCT ipInterface.ipAddr, service.serviceName, node.nodeID FROM ipInterface JOIN ifServices ON (ipInterface.id = ifServices.ipInterfaceId) JOIN service ON (ifServices.serviceID = service.serviceID) JOIN node ON (ipInterface.nodeID = node.nodeID) WHERE IPLIKE(ipInterface.ipaddr, '*.*.*.*')", (Object)this.m_dao.getInterfaceWithServiceStatement("ipaddr IPLIKE *.*.*.*"));
    }

    @Test
    @Transactional
    public void testGetIpv6InterfaceWithServiceStatement() throws Exception {
        Assert.assertEquals((String)"SQL from getIpv6InterfaceWithServiceStatement", (Object)"SELECT DISTINCT ipInterface.ipAddr, service.serviceName, node.nodeID FROM ipInterface JOIN ifServices ON (ipInterface.id = ifServices.ipInterfaceId) JOIN service ON (ifServices.serviceID = service.serviceID) JOIN node ON (ipInterface.nodeID = node.nodeID) WHERE IPLIKE(ipInterface.ipaddr, '*:*:*:*:*:*:*:*')", (Object)this.m_dao.getInterfaceWithServiceStatement("ipaddr IPLIKE *:*:*:*:*:*:*:*"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testWalkNodes() throws Exception {
        final ArrayList nodes = new ArrayList();
        AbstractEntityVisitor visitor = new AbstractEntityVisitor(){

            public void visitNode(OnmsNode node) {
                nodes.add(node);
            }
        };
        FilterWalker walker = new FilterWalker();
        walker.setFilterDao((FilterDao)this.m_dao);
        walker.setNodeDao(this.m_nodeDao);
        walker.setFilter("ipaddr == '10.1.1.1'");
        walker.setVisitor((EntityVisitor)visitor);
        walker.walk();
        Assert.assertEquals((String)"node list size", (long)1L, (long)nodes.size());
    }

    @Test
    @Transactional
    public void testVariousWaysToMatchServiceNames() {
        Assert.assertEquals((String)"service statement", (Object)this.m_dao.getInterfaceWithServiceStatement("isFooService"), (Object)this.m_dao.getInterfaceWithServiceStatement("serviceName == 'FooService'"));
        Assert.assertEquals((String)"ip service mapping statement", (Object)this.m_dao.getIPServiceMappingStatement("isFooService"), (Object)this.m_dao.getIPServiceMappingStatement("serviceName == 'FooService'"));
        Assert.assertEquals((String)"ip service mapping statement", (Object)this.m_dao.getNodeMappingStatement("isFooService"), (Object)this.m_dao.getNodeMappingStatement("serviceName == 'FooService'"));
        this.m_dao.getInterfaceWithServiceStatement("serviceName == 'DiskUsage-/foo/bar'");
    }
}

