/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LocationMonitorDaoHibernateIT
implements InitializingBean {
    @Autowired
    private LocationMonitorDao m_locationMonitorDao;
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testSaveLocationMonitor() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "BogOS");
        pollerDetails.put("os.version", "sqrt(-1)");
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setId(UUID.randomUUID().toString());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastUpdated(new Date());
        mon.setProperties(pollerDetails);
        mon.setLocation("RDU");
        this.m_locationMonitorDao.save((Object)mon);
        this.m_locationMonitorDao.flush();
        this.m_locationMonitorDao.clear();
        OnmsLocationMonitor mon2 = (OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)((Object)mon.getId()));
        Assert.assertNotSame((Object)mon, (Object)mon2);
        Assert.assertEquals((Object)mon.getStatus(), (Object)mon2.getStatus());
        Assert.assertEquals((Object)mon.getLastUpdated(), (Object)mon2.getLastUpdated());
        Assert.assertEquals((Object)mon.getLocation(), (Object)mon2.getLocation());
        Assert.assertEquals((Object)mon.getProperties(), (Object)mon2.getProperties());
    }

    @Test
    @Transactional
    public void testFindMonitoringLocationDefinitionNull() throws FileNotFoundException {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.m_monitoringLocationDao.get(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @Transactional
    public void testFindMonitoringLocationDefinitionBogus() throws FileNotFoundException {
        Assert.assertNull((String)"should not have found monitoring location definition--should have returned null", (Object)this.m_monitoringLocationDao.get((Serializable)((Object)"bogus")));
    }

    @Test
    @Transactional
    public void testFindStatusChangesForNodeForUniqueMonitorAndInterface() {
        this.m_databasePopulator.populateDatabase();
        OnmsLocationMonitor monitor1 = new OnmsLocationMonitor();
        monitor1.setId(UUID.randomUUID().toString());
        monitor1.setLocation("Outer Space");
        this.m_locationMonitorDao.save((Object)monitor1);
        OnmsLocationMonitor monitor2 = new OnmsLocationMonitor();
        monitor2.setId(UUID.randomUUID().toString());
        monitor2.setLocation("Really Outer Space");
        this.m_locationMonitorDao.save((Object)monitor2);
        OnmsNode node1 = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(1));
        Assert.assertNotNull((String)"node 1 should not be null", (Object)node1);
        OnmsNode node2 = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(2));
        Assert.assertNotNull((String)"node 2 should not be null", (Object)node2);
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.2").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor2, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("fe80::aaaa:bbbb:cccc:dddd%5").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node2.getIpInterfaceByIpAddress("192.168.2.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        Collection statuses = this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(1);
        Assert.assertEquals((String)"number of statuses found", (long)4L, (long)statuses.size());
    }

    private void addStatusChangesForMonitorAndService(OnmsLocationMonitor monitor, Set<OnmsMonitoredService> services) {
        for (OnmsMonitoredService service : services) {
            OnmsLocationSpecificStatus status = new OnmsLocationSpecificStatus();
            status.setLocationMonitor(monitor);
            status.setMonitoredService(service);
            status.setPollResult(PollStatus.available());
            this.m_locationMonitorDao.saveStatusChange(status);
        }
    }
}

