/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class NodeSnmpResourceType
implements OnmsResourceType {
    private final ResourceStorageDao m_resourceStorageDao;

    public NodeSnmpResourceType(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }

    public String getName() {
        return "nodeSnmp";
    }

    public String getLabel() {
        return "SNMP Node Data";
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        try {
            this.checkForNodeSnmpResources(parent);
        }
        catch (ObjectRetrievalFailureException e) {
            return false;
        }
        return true;
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        if (!this.isResourceTypeOnParent(parent)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getResourceForNode(parent));
    }

    public OnmsResource getChildByName(OnmsResource parent, String name) {
        if (!"".equals(name)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("Unsupported name '" + name + "' for node SNMP resource type."));
        }
        this.checkForNodeSnmpResources(parent);
        return this.getResourceForNode(parent);
    }

    private OnmsResource getResourceForNode(OnmsResource node) {
        Set attributes = this.m_resourceStorageDao.getAttributes(node.getPath());
        OnmsResource resource = new OnmsResource("", "Node-level Performance Data", (OnmsResourceType)this, attributes, node.getPath());
        resource.setParent(node);
        return resource;
    }

    private void checkForNodeSnmpResources(OnmsResource parent) {
        if (!NodeResourceType.isNode(parent)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("Invalid parent type '" + parent + "' for node SNMP resource type."));
        }
        if (!this.m_resourceStorageDao.exists(parent.getPath(), 0)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No metrics found in parent path '" + parent.getPath() + "'"));
        }
    }
}

