/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.support.TopNAttributeStatisticVisitor;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.AttributeStatistic;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.test.ThrowableAnticipator;

public class TopNAttributeStatisticVisitorTest
extends TestCase {
    public void testAfterPropertiesSet() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
    }

    public void testAfterPropertiesSetNoCount() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property count must be set to a non-null value"));
        visitor.setCount(null);
        try {
            visitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testVisit() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        HashMap<MockAttribute, Double> attributes = new HashMap<MockAttribute, Double>();
        attributes.put(new MockAttribute("foo"), 0.0);
        new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), attributes.keySet());
        for (Map.Entry entry : attributes.entrySet()) {
            visitor.visit((OnmsAttribute)entry.getKey(), ((Double)entry.getValue()).doubleValue());
        }
    }

    public void testVisitWithNull() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("attribute argument must not be null"));
        try {
            visitor.visit(null, 0.0);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testVisitGetResults() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        HashMap<MockAttribute, Double> attributes = new HashMap<MockAttribute, Double>();
        attributes.put(new MockAttribute("foo"), 0.0);
        new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), attributes.keySet());
        for (Map.Entry entry : attributes.entrySet()) {
            visitor.visit((OnmsAttribute)entry.getKey(), ((Double)entry.getValue()).doubleValue());
        }
        SortedSet top = visitor.getResults();
        TopNAttributeStatisticVisitorTest.assertNotNull((String)"topN list should not be null", (Object)top);
        TopNAttributeStatisticVisitorTest.assertEquals((String)"topN list size", (int)1, (int)top.size());
        int i = 0;
        for (AttributeStatistic stat : top) {
            TopNAttributeStatisticVisitorTest.assertEquals((String)("topN[" + i + "] value"), (Object)0.0, (Object)stat.getStatistic());
        }
    }

    public void testVisitGetResultsSameValue() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        HashMap<MockAttribute, Double> attributes = new HashMap<MockAttribute, Double>();
        for (int i = 0; i < 5; ++i) {
            attributes.put(new MockAttribute("foo"), 0.0);
        }
        new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), attributes.keySet());
        for (Map.Entry entry : attributes.entrySet()) {
            visitor.visit((OnmsAttribute)entry.getKey(), ((Double)entry.getValue()).doubleValue());
        }
        SortedSet top = visitor.getResults();
        TopNAttributeStatisticVisitorTest.assertNotNull((String)"topN list should not be null", (Object)top);
        TopNAttributeStatisticVisitorTest.assertEquals((String)"topN list size", (int)5, (int)top.size());
        int i = 0;
        for (AttributeStatistic stat : top) {
            TopNAttributeStatisticVisitorTest.assertEquals((String)("topN[" + i + "] value"), (Object)0.0, (Object)stat.getStatistic());
            ++i;
        }
    }

    public void testVisitGetResultsDifferentValues() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        HashMap<MockAttribute, Double> attributes = new HashMap<MockAttribute, Double>();
        for (int i = 0; i < 5; ++i) {
            attributes.put(new MockAttribute("foo"), 0.0 + (double)i);
        }
        new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), attributes.keySet());
        for (Map.Entry entry : attributes.entrySet()) {
            visitor.visit((OnmsAttribute)entry.getKey(), ((Double)entry.getValue()).doubleValue());
        }
        SortedSet top = visitor.getResults();
        TopNAttributeStatisticVisitorTest.assertNotNull((String)"topN list should not be null", (Object)top);
        TopNAttributeStatisticVisitorTest.assertEquals((String)"topN list size", (int)5, (int)top.size());
        int i = 0;
        for (AttributeStatistic stat : top) {
            TopNAttributeStatisticVisitorTest.assertEquals((String)("topN[" + i + "] value"), (Object)(4.0 - (double)i), (Object)stat.getStatistic());
            ++i;
        }
    }

    public void testVisitGetResultsLimitedByCount() throws Exception {
        TopNAttributeStatisticVisitor visitor = new TopNAttributeStatisticVisitor();
        visitor.setCount(Integer.valueOf(20));
        visitor.afterPropertiesSet();
        HashMap<MockAttribute, Double> attributes = new HashMap<MockAttribute, Double>();
        for (int i = 0; i < 100; ++i) {
            attributes.put(new MockAttribute("foo"), 0.0 + (double)i);
        }
        new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), attributes.keySet());
        for (Map.Entry entry : attributes.entrySet()) {
            visitor.visit((OnmsAttribute)entry.getKey(), ((Double)entry.getValue()).doubleValue());
        }
        SortedSet top = visitor.getResults();
        TopNAttributeStatisticVisitorTest.assertNotNull((String)"topN list should not be null", (Object)top);
        TopNAttributeStatisticVisitorTest.assertEquals((String)"topN list size", (int)20, (int)top.size());
        int i = 0;
        for (AttributeStatistic stat : top) {
            TopNAttributeStatisticVisitorTest.assertEquals((String)("topN[" + i + "] value"), (Object)(99.0 - (double)i), (Object)stat.getStatistic());
            ++i;
        }
    }

    public class MockAttribute
    implements OnmsAttribute {
        private String m_name;
        private OnmsResource m_resource;

        public MockAttribute(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public OnmsResource getResource() {
            return this.m_resource;
        }

        public void setResource(OnmsResource resource) {
            this.m_resource = resource;
        }
    }
}

