/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;

public class ResponseTimeResourceTypeTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private DefaultResourceDao resourceDao = new DefaultResourceDao();
    private NodeDao nodeDao = (NodeDao)EasyMock.createMock(NodeDao.class);
    private IpInterfaceDao ipInterfaceDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
    private OnmsNode node = (OnmsNode)EasyMock.createMock(OnmsNode.class);
    private OnmsIpInterface ipInterface = (OnmsIpInterface)EasyMock.createMock(OnmsIpInterface.class);
    private Set<OnmsIpInterface> ipInterfaces = new HashSet<OnmsIpInterface>();
    private ResponseTimeResourceType responseTimeResourceType = new ResponseTimeResourceType((ResourceDao)this.resourceDao, this.nodeDao, this.ipInterfaceDao);

    @Before
    public void setUp() {
        this.resourceDao.setRrdDirectory(this.tempFolder.getRoot());
        this.tempFolder.newFolder(new String[]{"response", "127.0.0.1"});
        this.ipInterfaces.add(this.ipInterface);
    }

    @Test
    public void canGetResourcesForNode() throws IOException {
        EasyMock.expect((Object)this.nodeDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)this.node);
        EasyMock.expect((Object)this.node.getIpInterfaces()).andReturn(this.ipInterfaces);
        EasyMock.expect((Object)this.ipInterface.getIpAddress()).andReturn((Object)InetAddress.getByName("127.0.0.1")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.nodeDao, this.node, this.ipInterface});
        List resources = this.responseTimeResourceType.getResourcesForNode(1);
        EasyMock.verify((Object[])new Object[]{this.nodeDao, this.node, this.ipInterface});
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((OnmsResource)resources.get(0)).getName());
    }

    @Test
    public void canGetChildByName() throws IOException {
        EasyMock.expect((Object)this.ipInterface.getIpAddress()).andReturn((Object)InetAddress.getByName("127.0.0.1")).atLeastOnce();
        EasyMock.expect((Object)this.ipInterfaceDao.get(this.node, "127.0.0.1")).andReturn((Object)this.ipInterface);
        OnmsResource parent = (OnmsResource)EasyMock.createMock(OnmsResource.class);
        EasyMock.expect((Object)parent.getEntity()).andReturn((Object)this.node);
        EasyMock.replay((Object[])new Object[]{this.ipInterface, parent, this.ipInterfaceDao});
        OnmsResource resource = this.responseTimeResourceType.getChildByName(parent, "127.0.0.1");
        EasyMock.verify((Object[])new Object[]{this.ipInterface, parent, this.ipInterfaceDao});
        Assert.assertEquals((Object)"127.0.0.1", (Object)resource.getName());
        Assert.assertEquals((Object)parent, (Object)resource.getParent());
    }
}

