/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTreeWalker;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceVisitor;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class ResourceTreeWalkerTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);
    private ResourceVisitor m_visitor = (ResourceVisitor)this.m_mocks.createMock(ResourceVisitor.class);

    public void setUp() throws Exception {
        super.setUp();
    }

    public void testAfterPropertiesSet() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(this.m_resourceDao);
        walker.setVisitor(this.m_visitor);
        this.m_mocks.replayAll();
        walker.afterPropertiesSet();
        this.m_mocks.verifyAll();
    }

    public void testAfterPropertiesSetNoResourceDao() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(null);
        walker.setVisitor(this.m_visitor);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property resourceDao must be set to a non-null value"));
        this.m_mocks.replayAll();
        try {
            walker.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_mocks.verifyAll();
    }

    public void testAfterPropertiesSetNoVisitor() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(this.m_resourceDao);
        walker.setVisitor(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property visitor must be set to a non-null value"));
        this.m_mocks.replayAll();
        try {
            walker.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_mocks.verifyAll();
    }

    public void testWalkEmptyList() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(this.m_resourceDao);
        walker.setVisitor(this.m_visitor);
        this.m_mocks.replayAll();
        walker.afterPropertiesSet();
        this.m_mocks.verifyAll();
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(new ArrayList(0));
        this.m_mocks.replayAll();
        walker.walk();
        this.m_mocks.verifyAll();
    }

    public void testWalkTopLevel() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(this.m_resourceDao);
        walker.setVisitor(this.m_visitor);
        this.m_mocks.replayAll();
        walker.afterPropertiesSet();
        this.m_mocks.verifyAll();
        MockResourceType resourceType = new MockResourceType();
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>(2);
        resources.add(new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, new HashSet(0)));
        resources.add(new OnmsResource("2", "Node Two", (OnmsResourceType)resourceType, new HashSet(0)));
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(resources);
        for (OnmsResource resource : resources) {
            this.m_visitor.visit(resource);
        }
        this.m_mocks.replayAll();
        walker.walk();
        this.m_mocks.verifyAll();
    }

    public void testWalkChildren() {
        ResourceTreeWalker walker = new ResourceTreeWalker();
        walker.setResourceDao(this.m_resourceDao);
        walker.setVisitor(this.m_visitor);
        this.m_mocks.replayAll();
        walker.afterPropertiesSet();
        this.m_mocks.verifyAll();
        MockResourceType resourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface eth0", (OnmsResourceType)resourceType, new HashSet(0));
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, new HashSet(0), Collections.singletonList(childResource));
        EasyMock.expect((Object)this.m_resourceDao.findTopLevelResources()).andReturn(Collections.singletonList(topResource));
        this.m_visitor.visit(topResource);
        this.m_visitor.visit(childResource);
        this.m_mocks.replayAll();
        walker.walk();
        this.m_mocks.verifyAll();
    }
}

