/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.IOException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;

public class NodeSnmpResourceTypeTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void canGetChildByName() throws IOException {
        OnmsNode node = (OnmsNode)EasyMock.createMock(OnmsNode.class);
        OnmsResource parent = (OnmsResource)EasyMock.createMock(OnmsResource.class);
        EasyMock.expect((Object)node.getId()).andReturn((Object)1);
        EasyMock.expect((Object)parent.getId()).andReturn((Object)"node[1]");
        EasyMock.expect((Object)parent.getEntity()).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{parent, node});
        DefaultResourceDao resourceDao = new DefaultResourceDao();
        resourceDao.setRrdDirectory(this.tempFolder.getRoot());
        NodeSnmpResourceType nodeSnmpResourceType = new NodeSnmpResourceType((ResourceDao)resourceDao);
        OnmsResource resource = nodeSnmpResourceType.getChildByName(parent, new String(""));
        Assert.assertEquals((Object)"node[1].nodeSnmp[]", (Object)resource.getId());
        Assert.assertEquals((Object)parent, (Object)resource.getParent());
    }
}

