/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.StorageStrategyService;
import org.opennms.netmgt.dao.support.HostFileSystemStorageStrategy;
import org.opennms.netmgt.dao.support.MockCollectionResource;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public class HostFileSystemStorageStrategyTest {
    @Test
    public void testStrategy() throws Exception {
        StorageStrategyService service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(InetAddressUtils.addr((String)"127.0.0.1"));
        agentConfig.setPort(1161);
        EasyMock.expect((Object)service.getAgentConfig()).andReturn((Object)agentConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{service});
        HostFileSystemStorageStrategy strategy = new HostFileSystemStorageStrategy();
        strategy.setResourceTypeName("hrStorageIndex");
        strategy.setStorageStrategyService(service);
        String parentResource = "1";
        MockCollectionResource resource = new MockCollectionResource(parentResource, "1", "hrStorageIndex");
        resource.getAttributeMap().put("hrStorageDescr", "/");
        String resourceName = strategy.getResourceNameFromIndex((CollectionResource)resource);
        Assert.assertEquals((Object)"_root_fs", (Object)resourceName);
        resource.setInstance("8");
        resource.getAttributeMap().put("hrStorageDescr", "Volumes-iDisk");
        Assert.assertEquals((Object)"Volumes-iDisk", (Object)strategy.getResourceNameFromIndex((CollectionResource)resource));
        Assert.assertEquals((Object)("1" + File.separator + "hrStorageIndex" + File.separator + "_root_fs"), (Object)strategy.getRelativePathForAttribute(parentResource, resourceName));
        EasyMock.verify((Object[])new Object[]{service});
    }
}

