/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jmx;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.jmx.JmxDaemonStatusDao;
import org.opennms.netmgt.dao.jmx.JmxObjectNameException;
import org.opennms.netmgt.model.MockServiceDaemon;
import org.opennms.netmgt.model.ServiceInfo;

public class JmxDaemonStatusDaoTest
extends TestCase {
    private static MBeanServer mBeanServer;
    private static ObjectName[] objectName;
    private static String[] names;
    private JmxDaemonStatusDao jmxDaemonStatusDao;

    protected void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 4; ++i) {
            MockServiceDaemon serviceDaemonStub = new MockServiceDaemon(names[i]);
            serviceDaemonStub.start();
            mBeanServer.registerMBean(serviceDaemonStub, objectName[i]);
        }
        this.jmxDaemonStatusDao = new JmxDaemonStatusDao();
        this.jmxDaemonStatusDao.setMbeanServer(mBeanServer);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (int i = 0; i < 4; ++i) {
            mBeanServer.unregisterMBean(objectName[i]);
        }
    }

    public void testGetAllStatuses() {
        try {
            Map services = this.jmxDaemonStatusDao.getCurrentDaemonStatus();
            JmxDaemonStatusDaoTest.assertEquals((String)"Unexpected number of mbeans found", (int)4, (int)services.size());
            ServiceInfo service = (ServiceInfo)services.get("notifd");
            String status = service.getServiceStatus();
            JmxDaemonStatusDaoTest.assertEquals((String)"Unexpected State: ", (String)"Started", (String)status);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testGetServiceHandleForValidService() {
    }

    public void testGetServiceHandleForInvalidService() {
    }

    public void testGetServiceHandleForNullServiceStr() {
    }

    static {
        objectName = new ObjectName[4];
        names = new String[]{"test", "test2", "notifd", "test3"};
        mBeanServer = MBeanServerFactory.createMBeanServer();
        int i = 0;
        try {
            for (i = 0; i < 4; ++i) {
                JmxDaemonStatusDaoTest.objectName[i] = new ObjectName("opennms:Name=" + names[i]);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new JmxObjectNameException("Malformed name while initializing ObjectName with name '" + objectName[i] + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new JmxObjectNameException("Null value passed to new ObjectName -param '" + objectName[i] + "'", (Throwable)e);
        }
    }
}

