/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class IpInterfaceDaoHibernateTest
implements InitializingBean {
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private InetAddress m_testAddress;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
        this.m_testAddress = this.m_databasePopulator.getNode2().getPrimaryInterface().getIpAddress();
        OnmsNode n1 = this.m_databasePopulator.getNode1();
        OnmsIpInterface iface = new OnmsIpInterface(this.m_testAddress.getHostAddress(), n1);
        iface.setIsManaged("U");
        iface.setIsSnmpPrimary(PrimaryType.SECONDARY);
        OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(n1, 1001);
        iface.setSnmpInterface(snmpIf);
        snmpIf.getIpInterfaces().add(iface);
        n1.addIpInterface(iface);
        this.m_databasePopulator.getNodeDao().save((Object)n1);
    }

    @Test
    @Transactional
    public void testNMS4822() throws Exception {
        OnmsIpInterface ipIntf = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(this.m_databasePopulator.getNode1().getId(), this.m_testAddress.getHostAddress());
        Assert.assertFalse((boolean)ipIntf.isPrimary());
        Assert.assertFalse((boolean)ipIntf.isManaged());
        ipIntf = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(this.m_databasePopulator.getNode2().getId(), this.m_testAddress.getHostAddress());
        Assert.assertTrue((boolean)ipIntf.isPrimary());
        Assert.assertTrue((boolean)ipIntf.isManaged());
        Map map = this.m_ipInterfaceDao.getInterfacesForNodes();
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)this.m_databasePopulator.getNode2().getId(), map.get(this.m_testAddress));
    }
}

