/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class OutageDaoTest
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    TransactionTemplate m_transTemplate;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                OnmsServiceType t = new OnmsServiceType("ICMP");
                OutageDaoTest.this.m_serviceTypeDao.save((Object)t);
            }
        });
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("localhost");
        this.m_nodeDao.save((Object)node);
        OnmsIpInterface ipInterface = new OnmsIpInterface(InetAddressUtils.addr((String)"172.16.1.1"), node);
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName("ICMP");
        Assert.assertNotNull((Object)serviceType);
        OnmsMonitoredService monitoredService = new OnmsMonitoredService(ipInterface, serviceType);
        OnmsEvent event = new OnmsEvent();
        OnmsOutage outage = new OnmsOutage(new Date(), monitoredService);
        outage.setServiceLostEvent(event);
        this.m_outageDao.save((Object)outage);
        outage = (OnmsOutage)this.m_outageDao.load((Serializable)outage.getId());
        Assert.assertEquals((Object)"ICMP", (Object)outage.getMonitoredService().getServiceType().getName());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetMatchingOutages() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                OnmsNode node = new OnmsNode(OutageDaoTest.this.getLocalHostDistPoller());
                node.setLabel("localhost");
                OutageDaoTest.this.m_nodeDao.save((Object)node);
                OutageDaoTest.this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                String[] svcs = new String[]{"ICMP"};
                ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", Arrays.asList(svcs));
                Collection outages = OutageDaoTest.this.m_outageDao.matchingCurrentOutages(selector);
                Assert.assertEquals((String)"outage count", (long)1L, (long)outages.size());
            }
        });
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetMatchingOutagesWithEmptyServiceList() {
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                OnmsNode node = new OnmsNode(OutageDaoTest.this.getLocalHostDistPoller());
                node.setLabel("localhost");
                OutageDaoTest.this.m_nodeDao.save((Object)node);
                OutageDaoTest.this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", new ArrayList(0));
                Collection outages = OutageDaoTest.this.m_outageDao.matchingCurrentOutages(selector);
                Assert.assertEquals((long)1L, (long)outages.size());
            }
        });
    }

    @Test
    @Transactional
    public void testDuplicateOutages() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("shoes");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.insertEntitiesAndOutage("172.20.1.1", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("megaphone");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.17.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.18.1.2", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("grunties");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.3", "ICMP", node);
        List outages = this.m_outageDao.getNodeOutageSummaries(0);
        System.err.println(outages);
        Assert.assertEquals((long)3L, (long)outages.size());
    }

    @Test
    @Transactional
    public void testLimitDuplicateOutages() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("shoes");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.insertEntitiesAndOutage("172.20.1.1", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("megaphone");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.17.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.18.1.2", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("grunties");
        this.m_nodeDao.save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.3", "ICMP", node);
        List outages = this.m_outageDao.getNodeOutageSummaries(2);
        System.err.println(outages);
        Assert.assertEquals((long)2L, (long)outages.size());
        outages = this.m_outageDao.getNodeOutageSummaries(3);
        System.err.println(outages);
        Assert.assertEquals((long)3L, (long)outages.size());
        outages = this.m_outageDao.getNodeOutageSummaries(4);
        System.err.println(outages);
        Assert.assertEquals((long)3L, (long)outages.size());
        outages = this.m_outageDao.getNodeOutageSummaries(5);
        System.err.println(outages);
        Assert.assertEquals((long)3L, (long)outages.size());
    }

    private OnmsDistPoller getLocalHostDistPoller() {
        return (OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost"));
    }

    private OnmsOutage insertEntitiesAndOutage(String ipAddr, String serviceName, OnmsNode node) {
        OnmsIpInterface ipInterface = this.getIpInterface(ipAddr, node);
        OnmsServiceType serviceType = this.getServiceType(serviceName);
        OnmsMonitoredService monitoredService = this.getMonitoredService(ipInterface, serviceType);
        OnmsEvent event = this.getEvent();
        OnmsOutage outage = this.getOutage(monitoredService, event);
        return outage;
    }

    private OnmsOutage getOutage(OnmsMonitoredService monitoredService, OnmsEvent event) {
        OnmsOutage outage = new OnmsOutage(new Date(), monitoredService);
        outage.setServiceLostEvent(event);
        this.m_outageDao.save((Object)outage);
        return outage;
    }

    private OnmsEvent getEvent() {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.getLocalHostDistPoller());
        event.setEventUei("foo!");
        event.setEventTime(new Date());
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventSource("your mom");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.m_eventDao.save((Object)event);
        return event;
    }

    private OnmsMonitoredService getMonitoredService(OnmsIpInterface ipInterface, OnmsServiceType serviceType) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class).add((Criterion)Restrictions.eq((String)"ipInterface", (Object)ipInterface)).add((Criterion)Restrictions.eq((String)"serviceType", (Object)serviceType));
        List services = this.m_monitoredServiceDao.findMatching(criteria);
        OnmsMonitoredService monitoredService = services.size() > 0 ? (OnmsMonitoredService)services.get(0) : new OnmsMonitoredService(ipInterface, serviceType);
        this.m_monitoredServiceDao.save((Object)monitoredService);
        return monitoredService;
    }

    private OnmsServiceType getServiceType(String serviceName) {
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName(serviceName);
        Assert.assertNotNull((String)("Couldn't find " + serviceName + " in the database"), (Object)serviceType);
        return serviceType;
    }

    private OnmsIpInterface getIpInterface(String ipAddr, OnmsNode node) {
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(node.getId(), ipAddr);
        if (ipInterface == null) {
            ipInterface = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddr), node);
            this.m_ipInterfaceDao.save((Object)ipInterface);
        }
        return ipInterface;
    }
}

