/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.dao.api.MinionPropertyDao;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.model.minion.OnmsMinionProperty;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=true)
public class MinionDaoTest {
    @Autowired
    private MinionDao m_minionDao;
    @Autowired
    private MinionPropertyDao m_minionPropertyDao;

    @Before
    public void setUp() throws Exception {
        List minions = this.m_minionDao.findAll();
        for (OnmsMinion minion : minions) {
            this.m_minionDao.delete((Object)minion);
        }
        this.m_minionDao.flush();
    }

    @Test
    public void testQueryByLocation() throws Exception {
        Date now = new Date();
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Started", now));
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Stopped", now));
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "OtherLocation", "Stopped", now));
        Collection testMinions = this.m_minionDao.findByLocation("TestLocation");
        Assert.assertEquals((long)2L, (long)testMinions.size());
    }

    @Test
    public void testProperties() throws Exception {
        Date now = new Date();
        OnmsMinion a = new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Started", now);
        OnmsMinion b = new OnmsMinion(UUID.randomUUID().toString(), "OtherLocation", "Started", now);
        a.setProperty("Yes", "No");
        a.setProperty("Up", "Down");
        b.setProperty("Left", "Right");
        b.setProperty("Wrong", "Right");
        this.m_minionDao.save((Object)a);
        this.m_minionDao.save((Object)b);
        this.m_minionDao.flush();
        Collection props = this.m_minionPropertyDao.findAll();
        Assert.assertEquals((long)4L, (long)props.size());
        props = this.m_minionPropertyDao.findByMinionId(a.getId());
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)a.getId(), (Object)((OnmsMinionProperty)props.iterator().next()).getMinion().getId());
        OnmsMinionProperty prop = this.m_minionPropertyDao.findByKey(a.getId(), "Left");
        Assert.assertNull((Object)prop);
        prop = this.m_minionPropertyDao.findByKey(b.getId(), "Left");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"Right", (Object)prop.getValue());
    }
}

