/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class EventDaoTest
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        event.setEventCreateTime(new Date());
        event.setEventDescr("event dao test");
        event.setEventHost("localhost");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventLogGroup("event dao test log group");
        event.setEventLogMsg("event dao test log msg");
        event.setEventSeverity(Integer.valueOf(7));
        event.setEventSource("EventDaoTest");
        event.setEventTime(new Date());
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsIpInterface iface = (OnmsIpInterface)node.getIpInterfaces().iterator().next();
        OnmsMonitoredService service = (OnmsMonitoredService)iface.getMonitoredServices().iterator().next();
        event.setNode(node);
        event.setServiceType(service.getServiceType());
        OnmsAlarm alarm = new OnmsAlarm();
        event.setAlarm(alarm);
        event.setIpAddr(iface.getIpAddress());
        this.m_eventDao.save((Object)event);
        OnmsEvent newEvent = (OnmsEvent)this.m_eventDao.load((Serializable)event.getId());
        Assert.assertEquals((Object)"uei://org/opennms/test/EventDaoTest", (Object)newEvent.getEventUei());
        Assert.assertNotNull((Object)newEvent.getServiceType());
        Assert.assertEquals((Object)service.getNodeId(), (Object)newEvent.getNode().getId());
        Assert.assertEquals((Object)event.getIpAddr(), (Object)newEvent.getIpAddr());
    }

    @Test
    @Transactional
    public void testGetEventsAfterDate() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei/1");
        ueiList.add("uei/2");
        this.m_eventDao.getEventsAfterDate(ueiList, new Date());
    }
}

