/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.rrd.RrdRepository;

public class MockCollectionResource
implements CollectionResource {
    private final String parent;
    private String instance;
    private final String type;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public MockCollectionResource(String parent, String instance, String type) {
        this.parent = parent;
        this.instance = instance;
        this.type = type;
    }

    public String getOwnerName() {
        return null;
    }

    public File getResourceDir(RrdRepository repository) {
        return null;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return false;
    }

    public boolean rescanNeeded() {
        return false;
    }

    public void visit(CollectionSetVisitor visitor) {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            final MockCollectionResource resource = this;
            final String attrName = entry.getKey();
            final String attrValue = entry.getValue();
            CollectionAttribute attribute = new CollectionAttribute(){

                public CollectionResource getResource() {
                    return resource;
                }

                public String getStringValue() {
                    return attrValue;
                }

                public String getNumericValue() {
                    return attrValue;
                }

                public String getName() {
                    return attrName;
                }

                public void storeAttribute(Persister persister) {
                }

                public boolean shouldPersist(ServiceParameters params) {
                    return true;
                }

                public CollectionAttributeType getAttributeType() {
                    return null;
                }

                public void visit(CollectionSetVisitor visitor) {
                }

                public String getType() {
                    return "string";
                }

                public String getMetricIdentifier() {
                    return "MOCK_" + this.getName();
                }
            };
            visitor.visitAttribute(attribute);
        }
    }

    public String getResourceTypeName() {
        return this.type;
    }

    public String getParent() {
        return this.parent;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getInterfaceLabel() {
        return null;
    }

    public Map<String, String> getAttributeMap() {
        return this.attributes;
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

