/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.LinkStateDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LinkStateDaoHibernateTest
implements InitializingBean {
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private LinkStateDao m_linkStateDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testSaveLinkState() {
        List dlis = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertNotNull((Object)dlis);
        Assert.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        Assert.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState1);
        this.m_linkStateDao.flush();
        Integer id = linkState1.getId();
        Assert.assertNotNull((Object)id);
        OnmsLinkState linkState2 = (OnmsLinkState)this.m_linkStateDao.get((Serializable)id);
        Assert.assertNotNull((Object)linkState2);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
        linkState2.setLinkState(OnmsLinkState.LinkState.LINK_NODE_DOWN);
        this.m_linkStateDao.save((Object)linkState2);
        this.m_linkStateDao.flush();
        OnmsLinkState linkState3 = (OnmsLinkState)this.m_linkStateDao.get((Serializable)id);
        Assert.assertNotNull((Object)linkState3);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_NODE_DOWN, (Object)linkState3.getLinkState());
    }

    @Test
    @Transactional
    public void testSaveThenRead() {
        List dlis = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertNotNull((Object)dlis);
        Assert.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        Assert.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState1);
        this.m_linkStateDao.flush();
        Integer id = linkState1.getId();
        Assert.assertNotNull((Object)id);
        OnmsLinkState linkState2 = (OnmsLinkState)this.m_linkStateDao.get((Serializable)id);
        Assert.assertNotNull((Object)linkState2);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
    }

    @Test
    @Transactional
    public void testFindByDataLinkInterfaceId() {
        List dlis = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertNotNull((Object)dlis);
        Assert.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        int dataLinkId = dli.getId();
        Assert.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState1);
        this.m_linkStateDao.flush();
        OnmsLinkState linkState2 = this.m_linkStateDao.findByDataLinkInterfaceId(Integer.valueOf(dataLinkId));
        Assert.assertNotNull((Object)linkState2);
    }
}

