/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.net.InetAddress;
import java.util.ArrayList;
import junit.framework.Assert;
import org.easymock.EasyMock;
import org.junit.Test;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SiblingColumnStorageStrategyTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrategy() throws Exception {
        StorageStrategyService service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        SnmpAgentConfig agentConfig = new SnmpAgentConfig();
        agentConfig.setAddress(InetAddress.getByName("127.0.0.1"));
        agentConfig.setPort(1161);
        EasyMock.expect((Object)service.getAgentConfig()).andReturn((Object)agentConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{service});
        MockSnmpAgent snmpAgent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource("/mock-snmp-agent.properties"), (String)"127.0.0.1/1161");
        try {
            SiblingColumnStorageStrategy strategy = new SiblingColumnStorageStrategy();
            strategy.setResourceTypeName("hrStorageIndex");
            strategy.setStorageStrategyService(service);
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            params.add(this.createParameter("sibling-column-oid", ".1.3.6.1.2.1.25.2.3.1.3"));
            params.add(this.createParameter("replace-first", "s/^-$/_root_fs/"));
            params.add(this.createParameter("replace-first", "s/^-//"));
            params.add(this.createParameter("replace-all", "s/\\s//"));
            params.add(this.createParameter("replace-all", "s/:\\\\.*//"));
            strategy.setParameters(params);
            String parentResource = "1";
            String resourceName = strategy.getResourceNameFromIndex(parentResource, "1");
            Assert.assertEquals((String)"_root_fs", (String)resourceName);
            Assert.assertEquals((String)"Volumes-iDisk", (String)strategy.getResourceNameFromIndex(parentResource, "8"));
            Assert.assertEquals((String)"1/hrStorageIndex/_root_fs", (String)strategy.getRelativePathForAttribute(parentResource, resourceName, null));
        }
        finally {
            snmpAgent.shutDownAndWait();
        }
        EasyMock.verify((Object[])new Object[]{service});
    }

    private Parameter createParameter(String key, String value) {
        Parameter p = new Parameter();
        p.setKey(key);
        p.setValue(value);
        return p;
    }
}

