/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.net.InetAddress;
import junit.framework.Assert;
import org.easymock.EasyMock;
import org.junit.Test;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.dao.support.HostFileSystemStorageStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class HostFileSystemStorageStrategyTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrategy() throws Exception {
        StorageStrategyService service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        SnmpAgentConfig agentConfig = new SnmpAgentConfig();
        agentConfig.setAddress(InetAddress.getByName("127.0.0.1"));
        agentConfig.setPort(1161);
        EasyMock.expect((Object)service.getAgentConfig()).andReturn((Object)agentConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{service});
        MockSnmpAgent snmpAgent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource("/mock-snmp-agent.properties"), (String)"127.0.0.1/1161");
        try {
            HostFileSystemStorageStrategy strategy = new HostFileSystemStorageStrategy();
            strategy.setResourceTypeName("hrStorageIndex");
            strategy.setStorageStrategyService(service);
            String parentResource = "1";
            String resourceName = strategy.getResourceNameFromIndex(parentResource, "1");
            Assert.assertEquals((String)"_root_fs", (String)resourceName);
            Assert.assertEquals((String)"Volumes-iDisk", (String)strategy.getResourceNameFromIndex(parentResource, "8"));
            Assert.assertEquals((String)"1/hrStorageIndex/_root_fs", (String)strategy.getRelativePathForAttribute(parentResource, resourceName, null));
        }
        finally {
            snmpAgent.shutDownAndWait();
        }
        EasyMock.verify((Object[])new Object[]{service});
    }
}

