/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.support.DefaultRrdDao;
import org.opennms.netmgt.dao.support.MockResourceType;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;

public class DefaultRrdDaoIntegrationTest
extends TestCase {
    private FileAnticipator m_fileAnticipator;
    private RrdStrategy m_rrdStrategy;
    private DefaultRrdDao m_dao;

    public void setUp() throws Exception {
        super.setUp();
        RrdTestUtils.initialize();
        this.m_rrdStrategy = RrdUtils.getStrategy();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_dao = new DefaultRrdDao();
        this.m_dao.setRrdStrategy(this.m_rrdStrategy);
        this.m_dao.setRrdBaseDirectory(this.m_fileAnticipator.getTempDir());
        this.m_dao.setRrdBinaryPath("/bin/true");
        this.m_dao.afterPropertiesSet();
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
        super.tearDown();
    }

    public void testInit() {
    }

    public void testPrintValue() throws Exception {
        long start = System.currentTimeMillis();
        long end = start + 86400000L;
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", "snmp/1/eth0", "ifInOctets.jrb");
        HashSet<RrdGraphAttribute> attributeSet = new HashSet<RrdGraphAttribute>(1);
        attributeSet.add(attribute);
        MockResourceType childResourceType = new MockResourceType();
        OnmsResource childResource = new OnmsResource("eth0", "Interface One: eth0", (OnmsResourceType)childResourceType, attributeSet);
        childResource.setParent(topResource);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File node = this.m_fileAnticipator.tempDir(snmp, topResource.getName());
        File intf = this.m_fileAnticipator.tempDir(node, childResource.getName());
        RrdDataSource rrdDataSource = new RrdDataSource(attribute.getName(), "GAUGE", 600, "U", "U");
        Object def = this.m_rrdStrategy.createDefinition("test", intf.getAbsolutePath(), attribute.getName(), 600, Collections.singletonList(rrdDataSource), Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        this.m_rrdStrategy.createFile(def);
        File rrdFile = this.m_fileAnticipator.expecting(intf, attribute.getName() + RrdUtils.getExtension());
        Object rrdFileObject = this.m_rrdStrategy.openFile(rrdFile.getAbsolutePath());
        for (int i = 0; i < 10; ++i) {
            this.m_rrdStrategy.updateFile(rrdFileObject, "test", start / 1000L + (long)(300 * i) + ":1");
        }
        this.m_rrdStrategy.closeFile(rrdFileObject);
        Double value = this.m_dao.getPrintValue((OnmsAttribute)childResource.getAttributes().iterator().next(), "AVERAGE", start, end);
        DefaultRrdDaoIntegrationTest.assertNotNull((String)"value should not be null", (Object)value);
        DefaultRrdDaoIntegrationTest.assertEquals((String)"value", (Object)1.0, (Object)value);
    }
}

