/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.support.DefaultResourceDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.orm.ObjectRetrievalFailureException;

public class DefaultResourceDaoTest
extends TestCase {
    private EasyMockUtils m_easyMockUtils;
    private NodeDao m_nodeDao;
    private LocationMonitorDao m_locationMonitorDao;
    private CollectdConfigFactory m_collectdConfig;
    private DataCollectionConfig m_dataCollectionConfig;
    private DefaultResourceDao m_resourceDao;
    private FileAnticipator m_fileAnticipator;
    private FilterDao m_filterDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_nodeDao = (NodeDao)this.m_easyMockUtils.createMock(NodeDao.class);
        this.m_locationMonitorDao = (LocationMonitorDao)this.m_easyMockUtils.createMock(LocationMonitorDao.class);
        this.m_dataCollectionConfig = (DataCollectionConfig)this.m_easyMockUtils.createMock(DataCollectionConfig.class);
        this.m_filterDao = (FilterDao)this.m_easyMockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.expect((Object)this.m_filterDao.getIPList("IPADDR IPLIKE *.*.*.*")).andReturn(new ArrayList(0)).anyTimes();
        this.m_easyMockUtils.replayAll();
        this.setUpCollectdConfigFactory();
        this.m_easyMockUtils.verifyAll();
        this.m_resourceDao = new DefaultResourceDao();
        this.m_resourceDao.setNodeDao(this.m_nodeDao);
        this.m_resourceDao.setLocationMonitorDao(this.m_locationMonitorDao);
        this.m_resourceDao.setCollectdConfig(this.m_collectdConfig);
        this.m_resourceDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        this.m_resourceDao.setDataCollectionConfig(this.m_dataCollectionConfig);
        RrdTestUtils.initialize();
        EasyMock.expect((Object)this.m_dataCollectionConfig.getConfiguredResourceTypes()).andReturn(new HashMap());
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.afterPropertiesSet();
        this.m_easyMockUtils.verifyAll();
    }

    protected void tearDown() {
        this.m_fileAnticipator.tearDown();
    }

    private void setUpCollectdConfigFactory() throws MarshalException, ValidationException, IOException {
        InputStream stream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/collectdconfiguration-testdata.xml");
        this.m_collectdConfig = new CollectdConfigFactory(stream, "localhost", false);
        stream.close();
    }

    public void testGetResourceByIdNewEmpty() {
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.getResourceById("");
        this.m_easyMockUtils.verifyAll();
    }

    public void testGetResourceByIdNewTopLevelOnly() throws Exception {
        OnmsNode node = this.createNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById("node[1]");
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource should not be null", (Object)resource);
    }

    public void testGetResourceByIdNewTwoLevel() throws Exception {
        OnmsIpInterface ip = this.createIpInterfaceOnNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)ip.getNode().getId())).andReturn((Object)ip.getNode()).times(3);
        HashSet locMons = new HashSet();
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(1)).andReturn(locMons).times(1);
        File response = this.m_fileAnticipator.tempDir("response");
        File ipDir = this.m_fileAnticipator.tempDir(response, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById("node[1].responseTime[192.168.1.1]");
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource should not be null", (Object)resource);
    }

    public void testGetTopLevelResourceNodeExists() throws Exception {
        OnmsNode node = this.createNode();
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getTopLevelResource("node", node.getId().toString());
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetTopLevelResourceNodeDoesNotExist() {
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(2))).andReturn(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new ObjectRetrievalFailureException(OnmsNode.class, (Object)"2", "Top-level resource of resource type node could not be found: 2", null));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getTopLevelResource("node", "2");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetTopLevelResourceNodeExistsNoChildResources() throws Exception {
        OnmsNode node = this.createNode(2, "Node Two");
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)node.getId())).andReturn((Object)node).times(1);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getTopLevelResource("node", node.getId().toString());
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource should not be null", (Object)resource);
    }

    public void testGetTopLevelResourceDomainExists() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File domain = this.m_fileAnticipator.tempDir(snmp, "example1");
        File intf = this.m_fileAnticipator.tempDir(domain, "server1");
        this.m_fileAnticipator.tempFile(intf, "ifInOctects" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getTopLevelResource("domain", "example1");
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetTopLevelResourceDomainDoesNotExistInCollectdConfig() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new ObjectRetrievalFailureException(OnmsResource.class, (Object)"bogus", "Domain not found due to domain RRD directory not existing or not a directory: " + this.m_fileAnticipator.getTempDir() + "/snmp/bogus", null));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getTopLevelResource("domain", "bogus");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetTopLevelResourceDomainDoesNotExistNoInterfaceDirectories() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        this.m_fileAnticipator.tempDir(snmp, "example1");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        File dir = new File(new File(this.m_fileAnticipator.getTempDir(), "snmp"), "example1");
        ta.anticipate((Throwable)new ObjectRetrievalFailureException(OnmsResource.class, (Object)"example1", "Domain not found due to domain RRD directory not matching the domain directory filter: " + dir.getAbsolutePath(), null));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getTopLevelResource("domain", "example1");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetTopLevelResourceWithInvalidResourceType() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new ObjectRetrievalFailureException("Top-level resource type of 'bogus' is unknown", (Object)"bogus"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getTopLevelResource("bogus", "");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetResourceDomainInterfaceExists() throws IOException {
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File domain = this.m_fileAnticipator.tempDir(snmp, "example1");
        File intf = this.m_fileAnticipator.tempDir(domain, "server1");
        this.m_fileAnticipator.tempFile(intf, "ifInOctects" + RrdUtils.getExtension());
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"domain", "example1", "interfaceSnmp", "server1"});
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetResourceNoNode() throws Exception {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"node", "1", "nodeSnmp", ""});
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(1))).andReturn(null);
        this.m_easyMockUtils.replayAll();
        this.m_resourceDao.getResourceById(resourceId);
        this.m_easyMockUtils.verifyAll();
    }

    public void testFindNodeResourcesWithResponseTime() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File response = this.m_fileAnticipator.tempDir("response");
        File ipDir = this.m_fileAnticipator.tempDir(response, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource list should not be null", (Object)resources);
        DefaultResourceDaoTest.assertEquals((String)"resource list size", (int)1, (int)resources.size());
    }

    public void testFindNodeResourcesWithDistributedResponseTime() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File response = this.m_fileAnticipator.tempDir("response");
        File distributed = this.m_fileAnticipator.tempDir(response, "distributed");
        File monitor = this.m_fileAnticipator.tempDir(distributed, "1");
        File ipDir = this.m_fileAnticipator.tempDir(monitor, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource list should not be null", (Object)resources);
        DefaultResourceDaoTest.assertEquals((String)"resource list size", (int)1, (int)resources.size());
    }

    public void testFindNodeResourcesWithNodeSnmp() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(snmp, "1");
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource list should not be null", (Object)resources);
        DefaultResourceDaoTest.assertEquals((String)"resource list size", (int)1, (int)resources.size());
    }

    public void testFindNodeResourcesWithNodeInterface() throws Exception {
        LinkedList<OnmsNode> nodes = new LinkedList<OnmsNode>();
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        nodes.add(node);
        EasyMock.expect((Object)this.m_nodeDao.findAll()).andReturn(nodes);
        File snmp = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(snmp, "1");
        File intfDir = this.m_fileAnticipator.tempDir(nodeDir, "eth0");
        this.m_fileAnticipator.tempFile(intfDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        List resources = this.m_resourceDao.findNodeResources();
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"resource list should not be null", (Object)resources);
        DefaultResourceDaoTest.assertEquals((String)"resource list size", (int)1, (int)resources.size());
    }

    public void testGetResourceForNode() throws Exception {
        OnmsNode node = this.createNode();
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetResourceForNodeWithNullOnmsNode() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("node argument must not be null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getResourceForNode(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetResourceForIpInterface() throws Exception {
        OnmsNode node = this.createNode();
        OnmsIpInterface ip = this.createIpInterface();
        node.addIpInterface(ip);
        File response = this.m_fileAnticipator.tempDir("response");
        File ipDir = this.m_fileAnticipator.tempDir(response, "192.168.1.1");
        this.m_fileAnticipator.tempFile(ipDir, "icmp" + RrdUtils.getExtension());
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)ip.getNode()).times(2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(1)).andReturn(new ArrayList());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForIpInterface(ip);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetResourceForIpInterfaceWithNullOnmsIpInterface() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("ipInterface argument must not be null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getResourceForIpInterface(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetResourceForIpInterfaceWithNullNodeOnOnmsIpInterface() {
        OnmsIpInterface ip = this.createIpInterface();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("getNode() on ipInterface must not return null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_resourceDao.getResourceForIpInterface(ip);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testGetResourceForIpInterfaceWithLocationMonitor() throws Exception {
        OnmsIpInterface ip = this.createIpInterfaceOnNode();
        OnmsLocationMonitor locMon = new OnmsLocationMonitor();
        locMon.setId(Integer.valueOf(12345));
        File response = this.m_fileAnticipator.tempDir("response");
        File distributed = this.m_fileAnticipator.tempDir(response, "distributed");
        File locMonDir = this.m_fileAnticipator.tempDir(distributed, locMon.getId().toString());
        File ipDir = this.m_fileAnticipator.tempDir(locMonDir, ip.getIpAddress());
        this.m_fileAnticipator.tempFile(ipDir, "http" + RrdUtils.getExtension());
        ArrayList<LocationMonitorIpInterface> locationMonitorInterfaces = new ArrayList<LocationMonitorIpInterface>();
        locationMonitorInterfaces.add(new LocationMonitorIpInterface(locMon, ip));
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)ip.getNode().getId())).andReturn((Object)ip.getNode()).times(1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(ip.getNode().getId().intValue())).andReturn(locationMonitorInterfaces).times(2);
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForIpInterface(ip, locMon);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should not be null", (Object)resource);
    }

    public void testGetResourceForNodeWithData() throws Exception {
        OnmsNode node = this.createNode();
        File responseDir = this.m_fileAnticipator.tempDir("snmp");
        File nodeDir = this.m_fileAnticipator.tempDir(responseDir, node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "foo" + RrdUtils.getExtension());
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should exist", (Object)resource);
    }

    public void testGetResourceForNodeNoData() {
        OnmsNode node = this.createNode();
        this.m_easyMockUtils.replayAll();
        OnmsResource resource = this.m_resourceDao.getResourceForNode(node);
        this.m_easyMockUtils.verifyAll();
        DefaultResourceDaoTest.assertNotNull((String)"Resource should exist", (Object)resource);
    }

    private OnmsNode createNode() {
        return this.createNode(1, "Node One");
    }

    private OnmsNode createNode(int id, String label) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(id));
        node.setLabel(label);
        return node;
    }

    private OnmsIpInterface createIpInterface() {
        OnmsIpInterface ip = new OnmsIpInterface();
        ip.setIpAddress("192.168.1.1");
        return ip;
    }

    private OnmsIpInterface createIpInterfaceOnNode() {
        OnmsIpInterface ip = this.createIpInterface();
        this.createNode().addIpInterface(ip);
        return ip;
    }
}

