/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.Date;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.ReportCatalogEntry;

public class ReportCatalogDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    public void testSave() {
        Date date = new Date();
        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
        catalogEntry.setReportId("reportId_1");
        catalogEntry.setLocation("location_1");
        catalogEntry.setTitle("title_1");
        catalogEntry.setDate(date);
        this.getReportCatalogDao().save((Object)catalogEntry);
        Integer id = catalogEntry.getId();
        ReportCatalogEntry retrievedEntry = (ReportCatalogEntry)this.getReportCatalogDao().get((Serializable)id);
        ReportCatalogDaoHibernateTest.assertEquals((String)catalogEntry.getReportId(), (String)retrievedEntry.getReportId());
        ReportCatalogDaoHibernateTest.assertEquals((String)catalogEntry.getTitle(), (String)retrievedEntry.getTitle());
        ReportCatalogDaoHibernateTest.assertEquals((String)catalogEntry.getLocation(), (String)retrievedEntry.getLocation());
        ReportCatalogDaoHibernateTest.assertEquals((int)0, (int)catalogEntry.getDate().compareTo(retrievedEntry.getDate()));
    }

    public void testDelete() {
        Date date = new Date();
        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
        catalogEntry.setReportId("reportId_2");
        catalogEntry.setLocation("location_2");
        catalogEntry.setTitle("title_2");
        catalogEntry.setDate(date);
        this.getReportCatalogDao().save((Object)catalogEntry);
        Integer id = catalogEntry.getId();
        ReportCatalogDaoHibernateTest.assertNotNull((Object)this.getReportCatalogDao().get((Serializable)id));
        this.getReportCatalogDao().delete(id);
        ReportCatalogDaoHibernateTest.assertNull((Object)this.getReportCatalogDao().get((Serializable)id));
    }
}

