/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;

public class OnmsMapElementDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    public void testInitialize() {
    }

    public void testSaveOnmsMapElement() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap", "admin");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        OnmsMapElement mapElement = new OnmsMapElement(map, 2, "N", "Test Node Two", "unspecified", 0, 10);
        this.getOnmsMapElementDao().save((Object)mapElement);
        this.getOnmsMapElementDao().flush();
        this.getOnmsMapElementDao().clear();
        Object[] args = new Object[]{mapElement.getId()};
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from element where id = ?", args));
        OnmsMapElement mapElement2 = this.getOnmsMapElementDao().findElementById(mapElement.getId());
        OnmsMapElementDaoHibernateTest.assertNotSame((Object)mapElement, (Object)mapElement2);
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getMap().getId(), (int)mapElement2.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getElementId(), (int)mapElement2.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getType(), (String)mapElement2.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getLabel(), (String)mapElement2.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getIconName(), (String)mapElement2.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getX(), (int)mapElement2.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getY(), (int)mapElement2.getY());
    }

    public void testSaveOnmsMapElement1() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap1", "admin");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        OnmsMapElement mapElement = new OnmsMapElement(map, 2, "H", "Test Node Two", "unspecified", 0, 10);
        this.getOnmsMapElementDao().save((Object)mapElement);
        this.getOnmsMapElementDao().flush();
        this.getOnmsMapElementDao().clear();
        Object[] args = new Object[]{mapElement.getId()};
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from element where id = ?", args));
        OnmsMapElement mapElement2 = this.getOnmsMapElementDao().findElementById(mapElement.getId());
        OnmsMapElementDaoHibernateTest.assertNotSame((Object)mapElement, (Object)mapElement2);
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getMap().getId(), (int)mapElement2.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getElementId(), (int)mapElement2.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getType(), (String)mapElement2.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getLabel(), (String)mapElement2.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)mapElement.getIconName(), (String)mapElement2.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getX(), (int)mapElement2.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)mapElement.getY(), (int)mapElement2.getY());
    }

    public void testFindById() {
        OnmsMapElement mapElement = this.getOnmsMapElementDao().findElementById(59);
        OnmsMapElementDaoHibernateTest.assertEquals((int)58, (int)mapElement.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)mapElement.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"N", (String)mapElement.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"Test Node", (String)mapElement.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"unspecified", (String)mapElement.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)mapElement.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)10, (int)mapElement.getY());
    }

    public void testFind() {
        OnmsMap map = this.getOnmsMapDao().findMapById(58);
        OnmsMapElement mapElement = this.getOnmsMapElementDao().findElement(1, "N", map);
        OnmsMapElementDaoHibernateTest.assertEquals((int)58, (int)mapElement.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)mapElement.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"N", (String)mapElement.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"Test Node", (String)mapElement.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"unspecified", (String)mapElement.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)mapElement.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)10, (int)mapElement.getY());
    }

    public void testFindMapElementsByMapId() {
        OnmsMap map = this.getOnmsMapDao().findMapById(58);
        Collection elems = this.getOnmsMapElementDao().findElementsByMapId(map);
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        OnmsMapElementDaoHibernateTest.assertEquals((int)58, (int)mapElement.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)mapElement.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"N", (String)mapElement.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"Test Node", (String)mapElement.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"unspecified", (String)mapElement.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)mapElement.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)10, (int)mapElement.getY());
    }

    public void testFindElementsByElementIdAndType1() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(1, "N");
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        OnmsMapElementDaoHibernateTest.assertEquals((int)58, (int)mapElement.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)mapElement.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"N", (String)mapElement.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"Test Node", (String)mapElement.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"unspecified", (String)mapElement.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)mapElement.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)10, (int)mapElement.getY());
    }

    public void testFindElementsByElementIdAndType2() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(2, "N");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testFindElementsByElementIdAndType3() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(1, "M");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testFindElementsByElementIdAndType4() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(2, "M");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testFindElementsByElementIdAndType5() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(1, "H");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testFindElementsByElementIdAndType6() {
        Collection elems = this.getOnmsMapElementDao().findElementsByElementIdAndType(2, "H");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testFindElementsByType1() {
        Collection elems = this.getOnmsMapElementDao().findElementsByType("N");
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        OnmsMapElementDaoHibernateTest.assertEquals((int)58, (int)mapElement.getMap().getId());
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)mapElement.getElementId());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"N", (String)mapElement.getType());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"Test Node", (String)mapElement.getLabel());
        OnmsMapElementDaoHibernateTest.assertEquals((String)"unspecified", (String)mapElement.getIconName());
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)mapElement.getX());
        OnmsMapElementDaoHibernateTest.assertEquals((int)10, (int)mapElement.getY());
    }

    public void testFindElementsByType2() {
        Collection elems = this.getOnmsMapElementDao().findElementsByType("M");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)elems.size());
    }

    public void testDeleteElement() {
        Collection elems = this.getOnmsMapElementDao().findElementsByType("N");
        OnmsMapElementDaoHibernateTest.assertEquals((int)1, (int)elems.size());
        OnmsMapElement element = (OnmsMapElement)elems.iterator().next();
        this.getOnmsMapElementDao().delete((Object)element);
        OnmsMapElementDaoHibernateTest.assertNull((Object)this.getOnmsMapElementDao().findElementById(59));
    }

    public void testDeleteElementsByElementIdAndType() {
        this.getOnmsMapElementDao().deleteElementsByElementIdAndType(1, "N");
        OnmsMapElementDaoHibernateTest.assertNull((Object)this.getOnmsMapElementDao().findElementById(59));
    }

    public void testDeleteElementsByMapType() {
        this.getOnmsMapElementDao().deleteElementsByMapType("U");
        this.getOnmsMapElementDao().deleteElementsByMapType("A");
        OnmsMapElementDaoHibernateTest.assertEquals((int)0, (int)this.getOnmsMapElementDao().findAll().size());
    }
}

