/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsMap;

public class OnmsMapDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    public void testInitialize() {
    }

    public void testSaveOnmsMap() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap", "admin");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map, (Object)map2);
        OnmsMapDaoHibernateTest.assertEquals((String)map.getName(), (String)map2.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getOwner(), (String)map2.getOwner());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getType(), (String)"U");
        OnmsMapDaoHibernateTest.assertEquals((String)map.getUserLastModifies(), (String)map2.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
    }

    public void testSaveOnmsMap2() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap2", "admin", 969, 726);
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map, (Object)map2);
        OnmsMapDaoHibernateTest.assertEquals((String)map.getName(), (String)map2.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getOwner(), (String)map2.getOwner());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getType(), (String)"U");
        OnmsMapDaoHibernateTest.assertEquals((String)map.getAccessMode().trim(), (String)map2.getAccessMode().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getUserLastModifies(), (String)map2.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getWidth(), (int)map2.getWidth());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getHeight(), (int)map2.getHeight());
    }

    public void testSaveOnmsMap3() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap3", "admin", "RWRO", 969, 726);
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map, (Object)map2);
        OnmsMapDaoHibernateTest.assertEquals((String)map.getName(), (String)map2.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getOwner(), (String)map2.getOwner().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getType(), (String)"U");
        OnmsMapDaoHibernateTest.assertEquals((String)map.getAccessMode(), (String)map2.getAccessMode().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getUserLastModifies(), (String)map2.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getWidth(), (int)map2.getWidth());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getHeight(), (int)map2.getHeight());
    }

    public void testSaveOnmsMap4() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap4", "users", "11aabb", "admin", "RWRO", "U", 800, 600);
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map, (Object)map2);
        OnmsMapDaoHibernateTest.assertEquals((String)map.getName(), (String)map2.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getOwner(), (String)map2.getOwner());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getType(), (String)"U");
        OnmsMapDaoHibernateTest.assertEquals((String)map.getAccessMode(), (String)map2.getAccessMode().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getUserLastModifies(), (String)map2.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getWidth(), (int)map2.getWidth());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getHeight(), (int)map2.getHeight());
    }

    public void testSaveOnmsMap5() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap5", "users", "11aabb", "admin", "RWRO", "A", 800, 600);
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map, (Object)map2);
        OnmsMapDaoHibernateTest.assertEquals((String)map.getName(), (String)map2.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getOwner(), (String)map2.getOwner());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getType(), (String)"A");
        OnmsMapDaoHibernateTest.assertEquals((String)map.getAccessMode(), (String)map2.getAccessMode().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map.getUserLastModifies(), (String)map2.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getWidth(), (int)map2.getWidth());
        OnmsMapDaoHibernateTest.assertEquals((int)map.getHeight(), (int)map2.getHeight());
    }

    public void testSaveOnmsMap6() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap6", "users", "11aabb", "admin", "RWRO", "A", 800, 600);
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Object[] args = new Object[]{map.getId()};
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)this.getJdbcTemplate().queryForInt("select count(*) from map where mapId = ?", args));
        OnmsMap map2 = this.getOnmsMapDao().findMapById(map.getId());
        map2.setType("S");
        this.getOnmsMapDao().save((Object)map2);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        OnmsMap map3 = this.getOnmsMapDao().findMapById(map.getId());
        OnmsMapDaoHibernateTest.assertNotSame((Object)map2, (Object)map3);
        OnmsMapDaoHibernateTest.assertEquals((String)map2.getName(), (String)map3.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)map2.getOwner(), (String)map3.getOwner());
        OnmsMapDaoHibernateTest.assertEquals((String)map2.getType(), (String)"S");
        OnmsMapDaoHibernateTest.assertEquals((String)map2.getAccessMode(), (String)map3.getAccessMode().trim());
        OnmsMapDaoHibernateTest.assertEquals((String)map2.getUserLastModifies(), (String)map3.getUserLastModifies());
        OnmsMapDaoHibernateTest.assertEquals((Object)map2.getLastModifiedTime(), (Object)map3.getLastModifiedTime());
        OnmsMapDaoHibernateTest.assertEquals((Object)map2.getCreateTime(), (Object)map3.getCreateTime());
        OnmsMapDaoHibernateTest.assertEquals((int)map2.getWidth(), (int)map3.getWidth());
        OnmsMapDaoHibernateTest.assertEquals((int)map2.getHeight(), (int)map3.getHeight());
    }

    public void testFindById() {
        OnmsMap map = this.getOnmsMapDao().findMapById(58);
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapsByName() {
        Collection maps = this.getOnmsMapDao().findMapsByName("DB_Pop_Test_Map");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapsByNameAndTypeOk() {
        Collection maps = this.getOnmsMapDao().findMapsByNameAndType("DB_Pop_Test_Map", "U");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapsByNameAndTypeKo() {
        Collection maps = this.getOnmsMapDao().findMapsByNameAndType("DB_Pop_Test_Map", "A");
        OnmsMapDaoHibernateTest.assertEquals((int)0, (int)maps.size());
    }

    public void testFindMapsLike() {
        Collection maps = this.getOnmsMapDao().findMapsLike("Pop_Test");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapsByType() {
        Collection maps = this.getOnmsMapDao().findMapsByType("X");
        OnmsMapDaoHibernateTest.assertEquals((int)0, (int)maps.size());
    }

    public void testFindAutoMaps() {
        Collection maps = this.getOnmsMapDao().findAutoMaps();
        OnmsMapDaoHibernateTest.assertEquals((int)0, (int)maps.size());
    }

    public void testFindSaveMaps() {
        Collection maps = this.getOnmsMapDao().findSaveMaps();
        OnmsMapDaoHibernateTest.assertEquals((int)0, (int)maps.size());
    }

    public void testFindUserMaps() {
        Collection maps = this.getOnmsMapDao().findUserMaps();
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
    }

    public void testDeleteOnmsMap() {
        OnmsMap map = this.getOnmsMapDao().findMapById(58);
        this.getOnmsMapDao().delete((Object)map);
        OnmsMapDaoHibernateTest.assertNull((Object)this.getOnmsMapDao().findMapById(58));
    }

    public void testFindMapByOwner() {
        Collection maps = this.getOnmsMapDao().findMapsByOwner("admin");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapbyGroup() {
        Collection maps = this.getOnmsMapDao().findMapsByGroup("admin");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        OnmsMapDaoHibernateTest.assertEquals((String)"DB_Pop_Test_Map", (String)map.getName());
        OnmsMapDaoHibernateTest.assertEquals((String)"fake_background.jpg", (String)map.getBackground());
        OnmsMapDaoHibernateTest.assertEquals((String)"RW", (String)map.getAccessMode());
        OnmsMapDaoHibernateTest.assertEquals((String)"U", (String)map.getType());
    }

    public void testFindMapbyGroup1() {
        Collection maps = this.getOnmsMapDao().findMapsByGroup("");
        OnmsMapDaoHibernateTest.assertEquals((int)0, (int)maps.size());
    }

    public void testFindVisibleMapByGroup() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestVisibleMap", "admin", "RWRO", 969, 726);
        map.setMapGroup("testGroup");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Collection maps = this.getOnmsMapDao().findVisibleMapsByGroup("testGroup");
        OnmsMapDaoHibernateTest.assertEquals((int)2, (int)maps.size());
    }

    public void testFindVisibleMapByGroup2() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestVisibleMap", "admin", "RWRO", 969, 726);
        map.setMapGroup("testGroup");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        this.getOnmsMapDao().clear();
        Collection maps = this.getOnmsMapDao().findVisibleMapsByGroup("wrongGroup");
        OnmsMapDaoHibernateTest.assertEquals((int)1, (int)maps.size());
    }
}

