/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsLinkState;

public class LinkStateDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    public void testSaveLinkState() {
        List dlis = this.getDataLinkInterfaceDao().findAll();
        LinkStateDaoHibernateTest.assertNotNull((Object)dlis);
        LinkStateDaoHibernateTest.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        LinkStateDaoHibernateTest.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.getLinkStateDao().save((Object)linkState1);
        this.getLinkStateDao().flush();
        Integer id = linkState1.getId();
        LinkStateDaoHibernateTest.assertNotNull((Object)id);
        OnmsLinkState linkState2 = (OnmsLinkState)this.getLinkStateDao().get((Serializable)id);
        LinkStateDaoHibernateTest.assertNotNull((Object)linkState2);
        LinkStateDaoHibernateTest.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
        linkState2.setLinkState(OnmsLinkState.LinkState.LINK_NODE_DOWN);
        this.getLinkStateDao().save((Object)linkState2);
        this.getLinkStateDao().flush();
        OnmsLinkState linkState3 = (OnmsLinkState)this.getLinkStateDao().get((Serializable)id);
        LinkStateDaoHibernateTest.assertNotNull((Object)linkState3);
        LinkStateDaoHibernateTest.assertEquals((Object)OnmsLinkState.LinkState.LINK_NODE_DOWN, (Object)linkState3.getLinkState());
    }

    public void testSaveThenRead() {
        List dlis = this.getDataLinkInterfaceDao().findAll();
        LinkStateDaoHibernateTest.assertNotNull((Object)dlis);
        LinkStateDaoHibernateTest.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        LinkStateDaoHibernateTest.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.getLinkStateDao().save((Object)linkState1);
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
        Integer id = linkState1.getId();
        LinkStateDaoHibernateTest.assertNotNull((Object)id);
        OnmsLinkState linkState2 = (OnmsLinkState)this.getLinkStateDao().get((Serializable)id);
        LinkStateDaoHibernateTest.assertNotNull((Object)linkState2);
        LinkStateDaoHibernateTest.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
    }

    public void testFindByDataLinkInterfaceId() {
        List dlis = this.getDataLinkInterfaceDao().findAll();
        LinkStateDaoHibernateTest.assertNotNull((Object)dlis);
        LinkStateDaoHibernateTest.assertFalse((boolean)dlis.isEmpty());
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        int dataLinkId = dli.getId();
        LinkStateDaoHibernateTest.assertNotNull((Object)dli);
        OnmsLinkState linkState1 = new OnmsLinkState();
        linkState1.setDataLinkInterface(dli);
        this.getLinkStateDao().save((Object)linkState1);
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
        OnmsLinkState linkState2 = this.getLinkStateDao().findByDataLinkInterfaceId(Integer.valueOf(dataLinkId));
        LinkStateDaoHibernateTest.assertNotNull((Object)linkState2);
    }
}

