/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Map;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class IpInterfaceDaoHibernateTest
extends AbstractTransactionalDaoTestCase {
    private Integer m_node2Id;
    private String m_node2IpAddress;

    protected void onSetUpInTransactionIfEnabled() {
        super.onSetUpInTransactionIfEnabled();
        OnmsNode n2 = this.getNodeDao().findByForeignId("imported:", "2");
        this.m_node2Id = n2.getId();
        IpInterfaceDaoHibernateTest.assertNotNull((Object)this.m_node2Id);
        this.m_node2IpAddress = n2.getPrimaryInterface().getIpAddress();
        IpInterfaceDaoHibernateTest.assertNotNull((Object)this.m_node2IpAddress);
        OnmsNode n1 = this.getNode1();
        OnmsIpInterface iface = new OnmsIpInterface(this.m_node2IpAddress, n1);
        iface.setIsManaged("U");
        iface.setIsSnmpPrimary(OnmsIpInterface.PrimaryType.SECONDARY);
        OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(this.m_node2IpAddress, 1001, n1);
        iface.setSnmpInterface(snmpIf);
        snmpIf.getIpInterfaces().add(iface);
        n1.addIpInterface(iface);
        this.getNodeDao().save((Object)n1);
        this.getNodeDao().flush();
    }

    public void testNMS4822() throws Exception {
        OnmsIpInterface ipIntf = this.getIpInterfaceDao().findByNodeIdAndIpAddress(this.getNode1().getId(), this.m_node2IpAddress);
        IpInterfaceDaoHibernateTest.assertFalse((boolean)ipIntf.isPrimary());
        IpInterfaceDaoHibernateTest.assertFalse((boolean)ipIntf.isManaged());
        ipIntf = this.getIpInterfaceDao().findByNodeIdAndIpAddress(this.m_node2Id, this.m_node2IpAddress);
        IpInterfaceDaoHibernateTest.assertTrue((boolean)ipIntf.isPrimary());
        IpInterfaceDaoHibernateTest.assertTrue((boolean)ipIntf.isManaged());
        Map map = this.getIpInterfaceDao().getInterfacesForNodes();
        IpInterfaceDaoHibernateTest.assertNotNull((Object)map);
        IpInterfaceDaoHibernateTest.assertEquals((Object)this.m_node2Id, map.get(this.m_node2IpAddress));
    }
}

