/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerSetIpInterfaceKeysOnUpdateTest
extends PopulatedTemporaryDatabaseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceKeysOnUpdate() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 2, 'FILTER-NEEDS-CHANGED' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        this.executeSQL("UPDATE ifServices SET serviceID = 2 WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnUpdateTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices id", (int)3, (int)rs.getInt(1));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices ipInterfaceId", (int)2, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetIpInterfaceKeysOnUpdateIpAddressAllZeroes() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 2, 'FILTER-NEEDS-CHANGED' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'UPDATE ifServices SET ipAddr = '0.0.0.0' WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1': ERROR: IfServices Trigger Exception, Condition 0: ipAddr of 0.0.0.0 is not allowed in ifServices table"));
        try {
            this.executeSQL("UPDATE ifServices SET ipAddr = '0.0.0.0' WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceKeysOnUpdateNullIfIndexBoth() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        this.executeSQL("UPDATE ifServices SET ifIndex = null WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnUpdateTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices id", (int)2, (int)rs.getInt(1));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices ipInterfaceId", (int)1, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceKeysOnUpdateNullIfIndexInIfServices() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        this.executeSQL("UPDATE ifServices SET ifIndex = null WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnUpdateTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnUpdateTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceKeysOnUpdateNullIfIndexInIpInterface() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', null, 1)");
        this.executeSQL("UPDATE ifServices SET ifIndex = 1 WHERE nodeID = 1 AND ipAddr = '1.2.3.4' AND serviceID = 1");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnUpdateTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices id", (int)2, (int)rs.getInt(1));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertEquals((String)"expected ifServices ipInterfaceId", (int)1, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnUpdateTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }
}

