/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerSetIpInterfaceKeysOnInsertTest
extends PopulatedTemporaryDatabaseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIdInIfService() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnInsertTest.assertEquals((String)"expected ifServices id", (int)3, (int)rs.getInt(1));
            TriggerSetIpInterfaceKeysOnInsertTest.assertEquals((String)"expected ifServices ipInterfaceId", (int)2, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetIpInterfaceIdInIfServiceAllZeroesIpAddress() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '0.0.0.0', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '0.0.0.0', 1, 1)': ERROR: IfServices Trigger Exception, Condition 0: ipAddr of 0.0.0.0 is not allowed in ifServices table"));
        try {
            this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '0.0.0.0', 1, 1)");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIdInIfServiceNullIfIndexBoth() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', null, 1)");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnInsertTest.assertEquals((String)"expected ifServices id", (int)2, (int)rs.getInt(1));
            TriggerSetIpInterfaceKeysOnInsertTest.assertEquals((String)"expected ifServices ipInterfaceId", (int)1, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIdInIfServiceNullIfIndexInIfServices() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', null, 1)");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIdInIfServiceNullIfIndexInIpInterface() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id from ipInterface");
            TriggerSetIpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first results row from ipInterface", (boolean)rs.next());
            int ipInterfaceId = rs.getInt(1);
            this.executeSQL("INSERT INTO ifServices (ipInterfaceId, serviceID) VALUES ( " + ipInterfaceId + ", 1)");
            st = connection.createStatement();
            rs = st.executeQuery("SELECT id, ipInterfaceID from ifServices");
            TriggerSetIpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            rs.getInt(1);
            TriggerSetIpInterfaceKeysOnInsertTest.assertFalse((String)"ifServices.id should be non-null", (boolean)rs.wasNull());
            TriggerSetIpInterfaceKeysOnInsertTest.assertEquals((String)"ifServices.ipInterfaceId", (int)ipInterfaceId, (int)rs.getInt(2));
            TriggerSetIpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }
}

