/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerSetIfServiceKeysOnInsertTest
extends PopulatedTemporaryDatabaseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIfServiceIdInOutage() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        this.executeSQL("INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.4', now(), 1 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT outageId, ifServiceId from outages");
            TriggerSetIfServiceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetIfServiceKeysOnInsertTest.assertEquals((String)"expected outages outageId", (int)1, (int)rs.getInt(1));
            TriggerSetIfServiceKeysOnInsertTest.assertEquals((String)"expected outages ifServiceId", (int)3, (int)rs.getInt(2));
            TriggerSetIfServiceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetIfServiceIdInOutageNullNodeId() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, ipAddr, snmpIfIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', 1, 1)");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), null, '1.2.3.4', now(), 1 )': ERROR: Outages Trigger Exception, Condition 1: No service found for... nodeid: <NULL>  ipaddr: 1.2.3.4  serviceid: 1"));
        try {
            this.executeSQL("INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), null, '1.2.3.4', now(), 1 )");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testSetIfServiceIdInOutageNullServiceId() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        this.executeSQL("INSERT INTO service (serviceID, serviceName) VALUES ( 1, 'COFFEE-READY' )");
        this.executeSQL("INSERT INTO ifServices (nodeID, ipAddr, ifIndex, serviceID) VALUES ( 1, '1.2.3.4', null, 1)");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.4', now(), null )': ERROR: Outages Trigger Exception, Condition 1: No service found for... nodeid: 1  ipaddr: 1.2.3.4  serviceid: <NULL>"));
        try {
            this.executeSQL("INSERT INTO outages (outageId, nodeId, ipAddr, ifLostService, serviceID ) VALUES ( nextval('outageNxtId'), 1, '1.2.3.4', now(), null )");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }
}

