/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class TemporaryDatabaseExecutionListener
extends AbstractTestExecutionListener {
    private TemporaryDatabase m_database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(TestContext testContext) throws Exception {
        try {
            System.err.printf("TemporaryDatabaseExecutionListener.afterTestMethod(%s)\n", testContext);
            DataSource dataSource = DataSourceFactory.getInstance();
            TemporaryDatabase tempDb = this.findTemporaryDatabase(dataSource);
            if (tempDb != null) {
                tempDb.drop();
            }
        }
        finally {
            testContext.markApplicationContextDirty();
            testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    private TemporaryDatabase findTemporaryDatabase(DataSource dataSource) {
        if (dataSource instanceof TemporaryDatabase) {
            return (TemporaryDatabase)dataSource;
        }
        if (dataSource instanceof DelegatingDataSource) {
            return this.findTemporaryDatabase(((DelegatingDataSource)dataSource).getTargetDataSource());
        }
        return null;
    }

    private JUnitTemporaryDatabase findAnnotation(TestContext testContext) {
        JUnitTemporaryDatabase jtd = null;
        Method testMethod = testContext.getTestMethod();
        if (testMethod != null) {
            jtd = testMethod.getAnnotation(JUnitTemporaryDatabase.class);
        }
        if (jtd == null) {
            Class testClass = testContext.getTestClass();
            jtd = testClass.getAnnotation(JUnitTemporaryDatabase.class);
        }
        return jtd;
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        System.err.printf("TemporaryDatabaseExecutionListener.beforeTestMethod(%s)\n", testContext);
        if (testContext.getTestInstance() instanceof TemporaryDatabaseAware) {
            System.err.println("injecting TemporaryDatabase into TemporaryDatabaseAware test: " + testContext.getTestInstance().getClass().getSimpleName() + "." + testContext.getTestMethod().getName());
            ((TemporaryDatabaseAware)testContext.getTestInstance()).setTemporaryDatabase(this.m_database);
        }
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        System.err.printf("TemporaryDatabaseExecutionListener.prepareTestInstance(%s)\n", testContext);
        JUnitTemporaryDatabase jtd = this.findAnnotation(testContext);
        boolean useExisting = false;
        if (jtd != null && jtd.useExistingDatabase() != null) {
            useExisting = !jtd.useExistingDatabase().equals("");
        }
        String dbName = useExisting ? jtd.useExistingDatabase() : this.getDatabaseName(testContext);
        TemporaryDatabase temporaryDatabase = this.m_database = jtd == null ? new TemporaryDatabase(dbName, useExisting) : jtd.tempDbClass().getConstructor(String.class, Boolean.TYPE).newInstance(dbName, useExisting);
        this.m_database.setPopulateSchema(jtd == null ? true : jtd.populate() && !useExisting);
        try {
            this.m_database.create();
        }
        catch (Exception e) {
            System.err.printf("TemporaryDatabaseExecutionListener.prepareTestInstance: error while creating database: %s\n", e.getMessage());
        }
        LazyConnectionDataSourceProxy proxy = new LazyConnectionDataSourceProxy((DataSource)this.m_database);
        DataSourceFactory.setInstance((DataSource)proxy);
        System.err.printf("TemporaryDatabaseExecutionListener.prepareTestInstance(%s) prepared db %s\n", testContext, dbName);
    }

    private String getDatabaseName(TestContext testContext) {
        return String.format("opennms_test_%s", System.currentTimeMillis());
    }
}

