/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import org.opennms.netmgt.dao.db.InstallerDb;
import org.opennms.netmgt.dao.db.TemporaryDatabaseTestCase;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.util.StringUtils;

public class PopulatedTemporaryDatabaseTestCase
extends TemporaryDatabaseTestCase {
    private InstallerDb m_installerDb = new InstallerDb();
    private ByteArrayOutputStream m_outputStream;
    private boolean m_setupIpLike = false;
    private boolean m_insertData = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.initializeDatabase();
        }
        finally {
            this.m_installerDb.closeConnection();
        }
    }

    protected void initializeDatabase() throws Exception {
        if (!PopulatedTemporaryDatabaseTestCase.isEnabled()) {
            return;
        }
        this.resetOutputStream();
        this.m_installerDb.setDatabaseName(this.getTestDatabase());
        this.m_installerDb.setDataSource(this.getDataSource());
        this.m_installerDb.setAdminDataSource(this.getAdminDataSource());
        this.m_installerDb.setPostgresOpennmsUser(this.getAdminUser());
        this.m_installerDb.setCreateSqlLocation(ConfigurationTestUtils.getFileForConfigFile((String)"create.sql").getAbsolutePath());
        this.m_installerDb.setStoredProcedureDirectory(ConfigurationTestUtils.getFileForConfigFile((String)"getPercentAvailabilityInWindow.sql").getParentFile().getAbsolutePath());
        this.m_installerDb.readTables();
        this.m_installerDb.createSequences();
        this.m_installerDb.updatePlPgsql();
        this.m_installerDb.addStoredProcedures();
        if (this.m_setupIpLike) {
            this.m_installerDb.setPostgresIpLikeLocation(null);
            this.m_installerDb.updateIplike();
        }
        this.m_installerDb.createTables();
        if (this.m_insertData) {
            this.m_installerDb.insertData();
        }
    }

    protected File findIpLikeLibrary() {
        File topDir = ConfigurationTestUtils.getTopProjectDirectory();
        File ipLikeDir = new File(topDir, "opennms-iplike");
        PopulatedTemporaryDatabaseTestCase.assertTrue((String)("iplike directory exists at ../opennms-iplike: " + ipLikeDir.getAbsolutePath()), (boolean)ipLikeDir.exists());
        Object[] ipLikePlatformDirs = ipLikeDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().matches("opennms-iplike-.*") && file.isDirectory();
            }
        });
        PopulatedTemporaryDatabaseTestCase.assertTrue((String)("expecting at least one opennms iplike platform directory in " + ipLikeDir.getAbsolutePath() + "; got: " + StringUtils.arrayToDelimitedString((Object[])ipLikePlatformDirs, (String)", ")), (ipLikePlatformDirs.length > 0 ? 1 : 0) != 0);
        Object ipLikeFile = null;
        for (Object ipLikePlatformDir : ipLikePlatformDirs) {
            PopulatedTemporaryDatabaseTestCase.assertTrue((String)("iplike platform directory does not exist but was listed in directory listing: " + ((File)ipLikePlatformDir).getAbsolutePath()), (boolean)((File)ipLikePlatformDir).exists());
            File ipLikeTargetDir = new File((File)ipLikePlatformDir, "target");
            if (!ipLikeTargetDir.exists() || !ipLikeTargetDir.isDirectory()) continue;
            Object[] ipLikeFiles = ipLikeTargetDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().matches("opennms-iplike-.*\\.(so|dylib)");
                }
            });
            PopulatedTemporaryDatabaseTestCase.assertFalse((String)("expecting zero or one iplike file in " + ipLikeTargetDir.getAbsolutePath() + "; got: " + StringUtils.arrayToDelimitedString((Object[])ipLikeFiles, (String)", ")), (ipLikeFiles.length > 1 ? 1 : 0) != 0);
            if (ipLikeFiles.length != 1) continue;
            ipLikeFile = ipLikeFiles[0];
        }
        PopulatedTemporaryDatabaseTestCase.assertNotNull((String)("Could not find iplike shared object in a target directory in any of these directories: " + StringUtils.arrayToDelimitedString((Object[])ipLikePlatformDirs, (String)", ")), ipLikeFile);
        return ipLikeFile;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.m_outputStream;
    }

    public void resetOutputStream() {
        this.m_outputStream = new ByteArrayOutputStream();
        this.m_installerDb.setOutputStream(new PrintStream(this.m_outputStream));
    }

    public void setInsertData(boolean insertData) throws Exception {
        this.m_insertData = insertData;
    }

    public void setSetupIpLike(boolean setupIpLike) {
        this.m_setupIpLike = setupIpLike;
    }

    protected InstallerDb getInstallerDb() {
        return this.m_installerDb;
    }
}

