/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import junit.framework.TestCase;
import org.opennms.netmgt.dao.db.Column;

public class ColumnTest
extends TestCase {
    public void testColumnParsePlain() throws Exception {
        Column column = new Column();
        column.parse("x733ProbableCause integer");
        ColumnTest.assertEquals((String)"column toString", (String)"x733probablecause integer(4)", (String)column.toString());
        ColumnTest.assertFalse((String)"column should not have 'NOT NULL'", (boolean)column.isNotNull());
        ColumnTest.assertNull((String)"column should not have a DEFAULT value", (Object)column.getDefaultValue());
    }

    public void testColumnParseWithDefaultAndNotNull() throws Exception {
        Column column = new Column();
        column.parse("x733ProbableCause integer default 0 not null");
        ColumnTest.assertEquals((String)"column toString", (String)"x733probablecause integer(4) DEFAULT 0 NOT NULL", (String)column.toString());
        ColumnTest.assertTrue((String)"column should have 'NOT NULL'", (boolean)column.isNotNull());
        ColumnTest.assertEquals((String)"column DEFAULT value", (String)"0", (String)column.getDefaultValue());
    }

    public void testColumnParseWithDefaultDifferent() throws Exception {
        Column oldColumn = new Column();
        oldColumn.parse("x733ProbableCause integer NOT NULL");
        Column newColumn = new Column();
        newColumn.parse("x733ProbableCause integer DEFAULT 0 NOT NULL");
        ColumnTest.assertFalse((String)"new column should not equal old column", (boolean)newColumn.equals((Object)oldColumn));
        ColumnTest.assertFalse((String)"old column should not equal new column", (boolean)oldColumn.equals((Object)newColumn));
    }

    public void testColumnParseWithDefaultDifferentSpellingWithNextValSequence() throws Exception {
        Column oldColumn = new Column();
        oldColumn.parse("x733ProbableCause integer DEFAULT nextval('opennmsnxtid') NOT NULL");
        Column newColumn = new Column();
        newColumn.parse("x733ProbableCause integer DEFAULT nextval('opennmsNxtId') NOT NULL");
        ColumnTest.assertTrue((String)"old column should equal new column", (boolean)oldColumn.equals((Object)newColumn));
    }
}

