/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor.collector;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.castor.InvocationAnticipator;
import org.opennms.netmgt.dao.castor.collector.DataCollectionConfigFile;
import org.opennms.netmgt.dao.castor.collector.DataCollectionVisitor;
import org.springframework.core.io.ClassPathResource;

public class DataCollectionConfigFileTest
extends TestCase {
    private InvocationAnticipator m_invocationAnticipator;
    private DataCollectionVisitor m_visitor;

    protected void setUp() throws Exception {
        super.setUp();
        InvocationHandler noNullsAllowed = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Assert.assertNotNull((Object)args);
                Assert.assertEquals((int)1, (int)args.length);
                Assert.assertNotNull((Object)args[0]);
                return null;
            }
        };
        this.m_invocationAnticipator = new InvocationAnticipator(DataCollectionVisitor.class);
        this.m_invocationAnticipator.setInvocationHandler(noNullsAllowed);
        this.m_visitor = (DataCollectionVisitor)this.m_invocationAnticipator.getProxy();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testVisit() throws IOException {
        ClassPathResource resource = new ClassPathResource("/datacollectionconfigfile-testdata.xml");
        DataCollectionConfigFile configFile = new DataCollectionConfigFile(resource.getFile());
        this.anticipateVisits(1, "DataCollectionConfig");
        this.anticipateVisits(1, "SnmpCollection");
        this.anticipateVisits(1, "Rrd");
        this.anticipateVisits(4, "Rra");
        this.anticipateVisits(26, "SystemDef");
        this.anticipateVisits(4, "SysOid");
        this.anticipateVisits(22, "SysOidMask");
        this.anticipateVisits(0, "IpList");
        this.anticipateVisits(26, "Collect");
        this.anticipateVisits(69, "IncludeGroup");
        this.anticipateVisits(57, "Group");
        this.anticipateVisits(0, "SubGroup");
        this.anticipateVisits(809, "MibObj");
        configFile.visit(this.m_visitor);
        this.m_invocationAnticipator.verify();
    }

    private void anticipateVisits(int count, String visited) {
        this.m_invocationAnticipator.anticipateCalls(count, "visit" + visited);
        this.m_invocationAnticipator.anticipateCalls(count, "complete" + visited);
    }
}

