/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.util.Properties;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.dao.JavaMailConfigurationDao;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
public class DefaultJavamailConfigurationDaoTest {
    @Autowired
    private JavaMailConfigurationDao m_jmcDao;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
    }

    @Test
    public void testWiring() {
        Assert.assertNotNull((Object)this.m_jmcDao);
    }

    @Test
    public void testMarshalling() {
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getDefaultReadmailConfig().getName());
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getDefaultSendmailConfig().getName());
        Assert.assertEquals((String)"false", (String)this.m_jmcDao.getDefaultReadmailConfig().getJavamailProperty(0).getValue());
        Assert.assertNotNull((Object)this.m_jmcDao.getEnd2EndConfig("default"));
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getEnd2EndConfig("default").getReadmailConfigName());
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getEnd2EndConfig("default").getSendmailConfigName());
    }
}

