/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.File;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.DatacollectionGroup;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.castor.DataCollectionConfigParser;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DataCollectionConfigParserTest {
    private static final int resourceTypesCount = 69;
    private static final int systemDefCount = 126;
    private static final int groupsCount = 183;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testLoadWithEmptyConfig() throws Exception {
        SnmpCollection collection = new SnmpCollection();
        collection.setName("default");
        Assert.assertEquals((long)0L, (long)collection.getIncludeCollectionCount());
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertNull((Object)collection.getSystems());
        Assert.assertNull((Object)collection.getGroups());
        File configFolder = this.getDatacollectionDirectory();
        DataCollectionConfigParser parser = new DataCollectionConfigParser(configFolder.getAbsolutePath());
        parser.parseCollection(collection);
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertNull((Object)collection.getSystems());
        Assert.assertNull((Object)collection.getGroups());
    }

    @Test
    public void testLoadWithOnlyExternalReferences() throws Exception {
        FileSystemResource resource = new FileSystemResource("src/test/resources/datacollection/datacollection-config-onlyimports.xml");
        DatacollectionConfig config = (DatacollectionConfig)CastorUtils.unmarshal(DatacollectionConfig.class, (Resource)resource, (boolean)false);
        SnmpCollection collection = config.getSnmpCollection(0);
        Assert.assertEquals((long)42L, (long)collection.getIncludeCollectionCount());
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertNull((Object)collection.getSystems());
        Assert.assertNull((Object)collection.getGroups());
        this.executeParser(collection);
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertEquals((long)126L, (long)collection.getSystems().getSystemDefCount());
        Assert.assertEquals((long)144L, (long)collection.getGroups().getGroupCount());
    }

    @Test
    public void testLoadHybridConfiguration() throws Exception {
        FileSystemResource resource = new FileSystemResource("src/test/resources/datacollection/datacollection-config-hybrid.xml");
        DatacollectionConfig config = (DatacollectionConfig)CastorUtils.unmarshal(DatacollectionConfig.class, (Resource)resource, (boolean)false);
        SnmpCollection collection = config.getSnmpCollection(0);
        Assert.assertEquals((long)12L, (long)collection.getIncludeCollectionCount());
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertEquals((long)1L, (long)collection.getSystems().getSystemDefCount());
        Assert.assertEquals((long)1L, (long)collection.getGroups().getGroupCount());
        this.executeParser(collection);
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertEquals((long)15L, (long)collection.getSystems().getSystemDefCount());
        Assert.assertEquals((long)61L, (long)collection.getGroups().getGroupCount());
    }

    @Test
    public void testLoadSimple() throws Exception {
        FileSystemResource resource = new FileSystemResource("src/test/resources/datacollection/datacollection-config-simple.xml");
        DatacollectionConfig config = (DatacollectionConfig)CastorUtils.unmarshal(DatacollectionConfig.class, (Resource)resource, (boolean)false);
        SnmpCollection collection = config.getSnmpCollection(0);
        Assert.assertEquals((long)1L, (long)collection.getIncludeCollectionCount());
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertNull((Object)collection.getSystems());
        Assert.assertNull((Object)collection.getGroups());
        this.executeParser(collection);
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertEquals((long)69L, (long)collection.getSystems().getSystemDefCount());
        Assert.assertEquals((long)26L, (long)collection.getGroups().getGroupCount());
    }

    @Test
    public void testLoadSimpleWithExclusions() throws Exception {
        FileSystemResource resource = new FileSystemResource("src/test/resources/datacollection/datacollection-config-excludes.xml");
        DatacollectionConfig config = (DatacollectionConfig)CastorUtils.unmarshal(DatacollectionConfig.class, (Resource)resource, (boolean)false);
        SnmpCollection collection = config.getSnmpCollection(0);
        Assert.assertEquals((long)1L, (long)collection.getIncludeCollectionCount());
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertNull((Object)collection.getSystems());
        Assert.assertNull((Object)collection.getGroups());
        this.executeParser(collection);
        Assert.assertEquals((long)0L, (long)collection.getResourceTypeCount());
        Assert.assertEquals((long)39L, (long)collection.getSystems().getSystemDefCount());
        Assert.assertEquals((long)25L, (long)collection.getGroups().getGroupCount());
    }

    private File getDatacollectionDirectory() {
        File configFile = new File("src/test/opennms-home/etc", "datacollection-config.xml");
        File configFolder = new File(configFile.getParentFile(), "datacollection");
        System.err.println(configFolder.getAbsolutePath());
        Assert.assertTrue((boolean)configFolder.isDirectory());
        return configFolder;
    }

    private void executeParser(SnmpCollection collection) {
        File configFolder = this.getDatacollectionDirectory();
        DataCollectionConfigParser parser = new DataCollectionConfigParser(configFolder.getAbsolutePath());
        parser.parseCollection(collection);
        this.validateParser(parser);
    }

    private void validateParser(DataCollectionConfigParser parser) {
        Map groupMap = parser.getExternalGroupMap();
        int currentResourceTypes = 0;
        int currentSystemDefs = 0;
        int currentMibGroups = 0;
        for (DatacollectionGroup group : groupMap.values()) {
            currentResourceTypes += group.getResourceTypeCount();
        }
        for (DatacollectionGroup group : groupMap.values()) {
            currentSystemDefs += group.getSystemDefCount();
        }
        for (DatacollectionGroup group : groupMap.values()) {
            currentMibGroups += group.getGroupCount();
        }
        Assert.assertEquals((long)69L, (long)currentResourceTypes);
        Assert.assertEquals((long)126L, (long)currentSystemDefs);
        Assert.assertEquals((long)183L, (long)currentMibGroups);
    }
}

