/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ServiceSelector;

public class OutageDaoTest
extends AbstractTransactionalDaoTestCase {
    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
    }

    protected void onSetUpInTransactionIfEnabled() {
        super.onSetUpInTransactionIfEnabled();
        FilterDaoFactory.setInstance(null);
        FilterDaoFactory.getInstance();
    }

    public void testSave() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        this.getNodeDao().save((Object)node);
        OnmsIpInterface ipInterface = new OnmsIpInterface("172.16.1.1", node);
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName("ICMP");
        OutageDaoTest.assertNotNull((Object)serviceType);
        OnmsMonitoredService monitoredService = new OnmsMonitoredService(ipInterface, serviceType);
        OnmsEvent event = new OnmsEvent();
        OnmsOutage outage = new OnmsOutage();
        outage.setServiceLostEvent(event);
        outage.setIfLostService(new Date());
        outage.setMonitoredService(monitoredService);
        this.getOutageDao().save((Object)outage);
        outage = (OnmsOutage)this.getOutageDao().load((Serializable)outage.getId());
        OutageDaoTest.assertEquals((String)"ICMP", (String)outage.getMonitoredService().getServiceType().getName());
    }

    public void testGetMatchingOutages() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.flushOutageDaoAndStartNewTransaction();
        String[] svcs = new String[]{"ICMP"};
        ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", Arrays.asList(svcs));
        Collection outages = this.getOutageDao().matchingCurrentOutages(selector);
        OutageDaoTest.assertEquals((String)"outage count", (int)1, (int)outages.size());
    }

    public void testGetMatchingOutagesWithEmptyServiceList() {
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.flushOutageDaoAndStartNewTransaction();
        ServiceSelector selector = new ServiceSelector("ipAddr IPLIKE 172.16.1.1", new ArrayList(0));
        Collection outages = this.getOutageDao().matchingCurrentOutages(selector);
        OutageDaoTest.assertEquals((int)1, (int)outages.size());
    }

    public void testDuplicateOutages() {
        for (OnmsNode node : this.getNodeDao().findAll()) {
            this.getNodeDao().delete((Object)node);
        }
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("shoes");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.insertEntitiesAndOutage("172.20.1.1", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("megaphone");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.17.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.18.1.2", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("grunties");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.3", "ICMP", node);
        List outages = this.getOutageDao().getNodeOutageSummaries(0);
        System.err.println(outages);
        OutageDaoTest.assertEquals((int)3, (int)outages.size());
    }

    public void testLimitDuplicateOutages() {
        for (OnmsNode node : this.getNodeDao().findAll()) {
            this.getNodeDao().delete((Object)node);
        }
        OnmsNode node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("shoes");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.1", "ICMP", node);
        this.insertEntitiesAndOutage("172.20.1.1", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("megaphone");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.17.1.2", "ICMP", node);
        this.insertEntitiesAndOutage("172.18.1.2", "ICMP", node);
        node = new OnmsNode(this.getLocalHostDistPoller());
        node.setLabel("grunties");
        this.getNodeDao().save((Object)node);
        this.insertEntitiesAndOutage("172.16.1.3", "ICMP", node);
        List outages = this.getOutageDao().getNodeOutageSummaries(2);
        System.err.println(outages);
        OutageDaoTest.assertEquals((int)2, (int)outages.size());
        outages = this.getOutageDao().getNodeOutageSummaries(3);
        System.err.println(outages);
        OutageDaoTest.assertEquals((int)3, (int)outages.size());
        outages = this.getOutageDao().getNodeOutageSummaries(4);
        System.err.println(outages);
        OutageDaoTest.assertEquals((int)3, (int)outages.size());
        outages = this.getOutageDao().getNodeOutageSummaries(5);
        System.err.println(outages);
        OutageDaoTest.assertEquals((int)3, (int)outages.size());
    }

    private OnmsDistPoller getLocalHostDistPoller() {
        return (OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost"));
    }

    private OnmsOutage insertEntitiesAndOutage(String ipAddr, String serviceName, OnmsNode node) {
        OnmsIpInterface ipInterface = this.getIpInterface(ipAddr, node);
        OnmsServiceType serviceType = this.getServiceType(serviceName);
        OnmsMonitoredService monitoredService = this.getMonitoredService(ipInterface, serviceType);
        OnmsEvent event = this.getEvent();
        OnmsOutage outage = this.getOutage(monitoredService, event);
        return outage;
    }

    private OnmsOutage getOutage(OnmsMonitoredService monitoredService, OnmsEvent event) {
        OnmsOutage outage = new OnmsOutage();
        outage.setMonitoredService(monitoredService);
        outage.setServiceLostEvent(event);
        outage.setIfLostService(new Date());
        this.getOutageDao().save((Object)outage);
        return outage;
    }

    private OnmsEvent getEvent() {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.getLocalHostDistPoller());
        event.setEventUei("foo!");
        event.setEventTime(new Date());
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventSource("your mom");
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.getEventDao().save((Object)event);
        return event;
    }

    private OnmsMonitoredService getMonitoredService(OnmsIpInterface ipInterface, OnmsServiceType serviceType) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsMonitoredService.class).add((Criterion)Restrictions.eq((String)"ipInterface", (Object)ipInterface)).add((Criterion)Restrictions.eq((String)"serviceType", (Object)serviceType));
        List services = this.getMonitoredServiceDao().findMatching(criteria);
        OnmsMonitoredService monitoredService = services.size() > 0 ? (OnmsMonitoredService)services.get(0) : new OnmsMonitoredService(ipInterface, serviceType);
        this.getMonitoredServiceDao().save((Object)monitoredService);
        return monitoredService;
    }

    private OnmsServiceType getServiceType(String serviceName) {
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName(serviceName);
        OutageDaoTest.assertNotNull((Object)serviceType);
        return serviceType;
    }

    private OnmsIpInterface getIpInterface(String ipAddr, OnmsNode node) {
        OnmsIpInterface ipInterface = this.getIpInterfaceDao().findByNodeIdAndIpAddress(node.getId(), ipAddr);
        if (ipInterface == null) {
            ipInterface = new OnmsIpInterface(ipAddr, node);
            this.getIpInterfaceDao().save((Object)ipInterface);
        }
        return ipInterface;
    }

    private void flushOutageDaoAndStartNewTransaction() {
        this.getOutageDao().flush();
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
    }
}

