/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"})
@JUnitTemporaryDatabase
public class NodeDaoTest {
    @Autowired
    DistPollerDao m_distPollerDao;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    DatabasePopulator m_populator;
    @Autowired
    TransactionTemplate m_transTemplate;

    @Before
    public void setUp() {
        this.m_populator.populateDatabase();
    }

    public OnmsNode getNode1() {
        return this.m_populator.getNode1();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.m_jdbcTemplate;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    @Test
    @Transactional
    public void testSave() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testSaveWithPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testSaveWithNullPathElement() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)"localhost"));
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        OnmsNode myNode = (OnmsNode)this.getNodeDao().get((Serializable)node.getId());
        myNode.setPathElement(null);
        this.getNodeDao().save((Object)myNode);
        this.getNodeDao().flush();
    }

    @Test
    @Transactional
    public void testCreate() throws InterruptedException {
        OnmsDistPoller distPoller = this.getDistPoller();
        OnmsNode node = new OnmsNode(distPoller);
        node.setLabel("MyFirstNode");
        node.getAssetRecord().setDisplayCategory("MyCategory");
        PathElement p = new PathElement("192.168.7.7", "ICMP");
        node.setPathElement(p);
        this.getNodeDao().save((Object)node);
        System.out.println("BEFORE GET");
        OnmsDistPoller dp = this.getDistPoller();
        Assert.assertSame((Object)distPoller, (Object)dp);
        System.out.println("AFTER GET");
        Collection nodes = this.getNodeDao().findNodes(dp);
        Assert.assertEquals((long)7L, (long)nodes.size());
        System.out.println("AFTER GETNODES");
        for (OnmsNode retrieved : nodes) {
            System.out.println("category for " + retrieved.getId() + " = " + retrieved.getAssetRecord().getDisplayCategory());
            if (node.getId() != 5) continue;
            Assert.assertEquals((Object)"MyFirstNode", (Object)retrieved.getLabel());
            Assert.assertEquals((Object)"MyCategory", (Object)retrieved.getAssetRecord().getDisplayCategory());
            Assert.assertEquals((Object)"192.168.7.7", (Object)retrieved.getPathElement().getIpAddress());
        }
        System.out.println("AFTER Loop");
    }

    @Test
    @Transactional
    public void testQuery() throws Exception {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        this.validateNode(n);
    }

    @Test
    @Transactional
    public void testDeleteOnOrphanIpInterface() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = 1");
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        Iterator it = n.getIpInterfaces().iterator();
        it.next();
        it.remove();
        this.getNodeDao().saveOrUpdate((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from ipinterface where ipinterface.nodeId = 1");
        Assert.assertEquals((long)(preCount - 1), (long)postCount);
    }

    @Test
    @Transactional
    public void testDeleteNode() {
        int preCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        this.getNodeDao().delete((Object)n);
        this.getNodeDao().flush();
        int postCount = this.getJdbcTemplate().queryForInt("select count(*) from node");
        Assert.assertEquals((long)(preCount - 1), (long)postCount);
    }

    @Test
    @Transactional
    public void testQueryWithHierarchy() throws Exception {
        OnmsNode n = this.getNodeDao().getHierarchy(Integer.valueOf(1));
        this.validateNode(n);
    }

    @Transactional
    public OnmsNode getNodeHierarchy(final int nodeId) {
        return (OnmsNode)this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<OnmsNode>(){

            public OnmsNode doInTransaction(TransactionStatus status) {
                return NodeDaoTest.this.getNodeDao().getHierarchy(Integer.valueOf(nodeId));
            }
        });
    }

    @Test
    public void testQueryWithHierarchyCloseTransaction() throws Exception {
        OnmsNode n = this.getNodeHierarchy(1);
        this.validateNode(n);
        for (OnmsIpInterface ip : n.getIpInterfaces()) {
            ip.getIpAddress();
            for (OnmsMonitoredService service : ip.getMonitoredServices()) {
                service.getServiceName();
            }
        }
        for (OnmsSnmpInterface snmp : n.getSnmpInterfaces()) {
            for (OnmsIpInterface ip : snmp.getIpInterfaces()) {
                ip.getIpAddress();
            }
        }
    }

    @Test
    @Transactional
    public void testGetForeignIdToNodeIdMap() {
        Map arMap = this.getNodeDao().getForeignIdToNodeIdMap("imported:");
        Assert.assertTrue((String)"Expected to find foriegnId 1", (boolean)arMap.containsKey("1"));
        OnmsNode node1 = (OnmsNode)this.getNodeDao().get((Serializable)arMap.get("1"));
        Assert.assertNotNull((String)"Exepected foreignId to be mapped to a node", (Object)node1);
        Assert.assertEquals((String)"Expected foreignId to be mapped to 'node1'", (Object)"node1", (Object)node1.getLabel());
    }

    @Test
    @Transactional
    public void testUpdateNodeScanStamp() {
        Date timestamp = new Date(27L);
        this.getNodeDao().updateNodeScanStamp(Integer.valueOf(1), timestamp);
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        Assert.assertEquals((Object)timestamp, (Object)n.getLastCapsdPoll());
    }

    @Test
    @Transactional
    public void testFindByForeignSourceAndIpAddress() {
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("NoSuchForeignSource", "192.168.1.1").size());
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("imported:", "192.167.7.7").size());
        Assert.assertEquals((long)1L, (long)this.getNodeDao().findByForeignSourceAndIpAddress("imported:", "192.168.1.1").size());
        Assert.assertEquals((long)1L, (long)this.getNodeDao().findByForeignSourceAndIpAddress(null, "10.1.1.1").size());
        Assert.assertEquals((long)0L, (long)this.getNodeDao().findByForeignSourceAndIpAddress(null, "192.167.7.7").size());
    }

    @Test
    public void testDeleteObsoleteInterfaces() {
        final Date timestampe = new Date(1234L);
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                NodeDaoTest.this.simulateScan(timestampe);
                return null;
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                NodeDaoTest.this.deleteObsoleteInterfaces(timestampe);
                return null;
            }
        });
        this.m_transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                NodeDaoTest.this.validateScan();
                return null;
            }
        });
    }

    private void validateScan() {
        OnmsNode after = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        Assert.assertEquals((long)1L, (long)after.getIpInterfaces().size());
        Assert.assertEquals((long)1L, (long)after.getSnmpInterfaces().size());
    }

    private void simulateScan(Date timestampe) {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(1));
        Assert.assertEquals((long)3L, (long)n.getIpInterfaces().size());
        Assert.assertEquals((long)3L, (long)n.getSnmpInterfaces().size());
        OnmsIpInterface iface = n.getIpInterfaceByIpAddress("192.168.1.1");
        Assert.assertNotNull((Object)iface);
        iface.setIpLastCapsdPoll(timestampe);
        OnmsSnmpInterface snmpIface = n.getSnmpInterfaceWithIfIndex(1);
        Assert.assertNotNull((Object)snmpIface);
        snmpIface.setLastCapsdPoll(timestampe);
        this.getNodeDao().saveOrUpdate((Object)n);
        this.getNodeDao().flush();
    }

    private void deleteObsoleteInterfaces(Date timestampe) {
        this.getNodeDao().deleteObsoleteInterfaces(Integer.valueOf(1), timestampe);
    }

    private void validateNode(OnmsNode n) throws Exception {
        Assert.assertNotNull((String)"Expected node to be non-null", (Object)n);
        Assert.assertNotNull((String)("Expected node " + n.getId() + " to have interfaces"), (Object)n.getIpInterfaces());
        Assert.assertEquals((String)("Unexpected number of interfaces for node " + n.getId()), (long)3L, (long)n.getIpInterfaces().size());
        Iterator i$ = n.getIpInterfaces().iterator();
        while (i$.hasNext()) {
            OnmsIpInterface o;
            OnmsIpInterface iface = o = (OnmsIpInterface)i$.next();
            Assert.assertNotNull((Object)iface);
            Assert.assertNotNull((Object)iface.getIpAddress());
        }
        this.assertNodeEquals(this.getNode1(), n);
    }

    private void assertNodeEquals(OnmsNode expected, OnmsNode actual) throws Exception {
        Assert.assertEquals((String)"Unexpected nodeId", (Object)expected.getId(), (Object)actual.getId());
        String[] properties = new String[]{"id", "label", "labelSource", "assetRecord.assetNumber", "distPoller.name", "sysContact", "sysName", "sysObjectId"};
        this.assertPropertiesEqual(properties, expected, actual);
        this.assertInterfaceSetsEqual(expected.getIpInterfaces(), actual.getIpInterfaces());
    }

    private <T> void assertSetsEqual(Set<T> expectedSet, Set<T> actualSet, String orderProperty, AssertEquals<T> comparer) throws Exception {
        TreeSet<Object> expectedSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        expectedSorted.addAll(expectedSet);
        TreeSet<Object> actualSorted = new TreeSet<Object>(new PropertyComparator(orderProperty));
        actualSorted.addAll(actualSet);
        Iterator expected = expectedSorted.iterator();
        Iterator actual = actualSorted.iterator();
        while (expected.hasNext() && actual.hasNext()) {
            comparer.assertEqual(expected.next(), actual.next());
        }
        if (expected.hasNext()) {
            Assert.fail((String)("Missing item " + expected.next() + " in the actual list"));
        }
        if (actual.hasNext()) {
            Assert.fail((String)("Unexpected item " + actual.next() + " in the actual list"));
        }
    }

    private void assertInterfaceSetsEqual(Set<OnmsIpInterface> expectedSet, Set<OnmsIpInterface> actualSet) throws Exception {
        this.assertSetsEqual(expectedSet, actualSet, "ipAddress", new AssertEquals<OnmsIpInterface>(){

            @Override
            public void assertEqual(OnmsIpInterface expected, OnmsIpInterface actual) throws Exception {
                NodeDaoTest.this.assertInterfaceEquals(expected, actual);
            }
        });
    }

    private void assertInterfaceEquals(OnmsIpInterface expected, OnmsIpInterface actual) throws Exception {
        String[] properties = new String[]{"ipAddress", "ifIndex", "ipHostName", "isManaged", "node.id"};
        this.assertPropertiesEqual(properties, expected, actual);
        this.assertServicesEquals(expected.getMonitoredServices(), actual.getMonitoredServices());
    }

    private void assertServicesEquals(Set<OnmsMonitoredService> expectedSet, Set<OnmsMonitoredService> actualSet) throws Exception {
        this.assertSetsEqual(expectedSet, actualSet, "serviceId", new AssertEquals<OnmsMonitoredService>(){

            @Override
            public void assertEqual(OnmsMonitoredService expected, OnmsMonitoredService actual) throws Exception {
                NodeDaoTest.this.assertServiceEquals(expected, actual);
            }
        });
    }

    protected void assertServiceEquals(OnmsMonitoredService expected, OnmsMonitoredService actual) {
        Assert.assertEquals((Object)expected.getServiceName(), (Object)actual.getServiceName());
    }

    private void assertPropertiesEqual(String[] properties, Object expected, Object actual) throws Exception {
        for (String property : properties) {
            this.assertPropertyEquals(property, expected, actual);
        }
    }

    private void assertPropertyEquals(String name, Object expected, Object actual) throws Exception {
        String expectedValue = BeanUtils.getProperty((Object)expected, (String)name);
        String actualValue = BeanUtils.getProperty((Object)actual, (String)name);
        Assert.assertEquals((String)("Unexpected value for property " + name + " on object " + expected), (Object)expectedValue, (Object)actualValue);
    }

    @Test
    @Transactional
    public void testQuery2() {
        OnmsNode n = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(6));
        Assert.assertNotNull((Object)n);
        Assert.assertEquals((long)3L, (long)n.getIpInterfaces().size());
        Assert.assertNotNull((Object)n.getAssetRecord());
        Assert.assertEquals((Object)"category1", (Object)n.getAssetRecord().getDisplayCategory());
    }

    private OnmsDistPoller getDistPoller() {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost"));
        Assert.assertNotNull((Object)distPoller);
        return distPoller;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AssertEquals<T> {
        public void assertEqual(T var1, T var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyComparator
    implements Comparator<Object> {
        String m_propertyName;

        public PropertyComparator(String propertyName) {
            this.m_propertyName = propertyName;
        }

        @Override
        public int compare(Object o1, Object o2) {
            try {
                String expectedValue = "" + BeanUtils.getProperty((Object)o1, (String)this.m_propertyName);
                String actualValue = "" + BeanUtils.getProperty((Object)o2, (String)this.m_propertyName);
                return expectedValue.compareTo(actualValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to compare property " + this.m_propertyName, e);
            }
        }
    }
}

