/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import junit.framework.Assert;
import org.opennms.netmgt.dao.AcknowledgmentDao;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.NotificationDao;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.UserNotificationDao;
import org.opennms.netmgt.dao.hibernate.LocationMonitorDaoHibernate;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsUserNotification;

public class DatabasePopulator {
    private DistPollerDao m_distPollerDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private ServiceTypeDao m_serviceTypeDao;
    private AssetRecordDao m_assetRecordDao;
    private CategoryDao m_categoryDao;
    private OutageDao m_outageDao;
    private EventDao m_eventDao;
    private AlarmDao m_alarmDao;
    private NotificationDao m_notificationDao;
    private UserNotificationDao m_userNotificationDao;
    private LocationMonitorDaoHibernate m_locationMonitorDao;
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    private AcknowledgmentDao m_acknowledgmentDao;
    private OnmsNode m_node1;

    public void populateDatabase() {
        OnmsDistPoller distPoller = this.getDistPoller("localhost", "127.0.0.1");
        OnmsCategory ac = this.getCategory("DEV_AC");
        OnmsCategory mid = this.getCategory("IMP_mid");
        OnmsCategory ops = this.getCategory("OPS_Online");
        OnmsCategory catRouter = this.getCategory("Routers");
        OnmsCategory catSwitches = this.getCategory("Switches");
        OnmsCategory catServers = this.getCategory("Servers");
        this.getCategory("Production");
        this.getCategory("Test");
        this.getCategory("Development");
        this.getServiceType("ICMP");
        this.getServiceType("SNMP");
        this.getServiceType("HTTP");
        NetworkBuilder builder = new NetworkBuilder(distPoller);
        this.setNode1(builder.addNode("node1").setForeignSource("imported:").setForeignId("1").getNode());
        Assert.assertNotNull((String)"newly built node 1 should not be null", (Object)this.getNode1());
        builder.addCategory(ac);
        builder.addCategory(mid);
        builder.addCategory(ops);
        builder.addCategory(catRouter);
        builder.setBuilding("HQ");
        builder.addInterface("192.168.1.1").setIsManaged("M").setIsSnmpPrimary("P").addSnmpInterface("192.168.1.1", 1).setCollectionEnabled(true).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).setIfDescr("ATM0").setIfType(Integer.valueOf(37));
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.1.2").setIsManaged("M").setIsSnmpPrimary("S").addSnmpInterface("192.168.1.2", 2).setCollectionEnabled(true).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).setIfName("eth0").setIfType(Integer.valueOf(6));
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.1.3").setIsManaged("M").setIsSnmpPrimary("N").addSnmpInterface("192.168.1.3", 3).setCollectionEnabled(false).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L);
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node2").setForeignSource("imported:").setForeignId("2");
        builder.addCategory(mid);
        builder.addCategory(catServers);
        builder.setBuilding("HQ");
        builder.addInterface("192.168.2.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.2.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.2.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node3").setForeignSource("imported:").setForeignId("3");
        builder.addCategory(ops);
        builder.addInterface("192.168.3.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.3.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.3.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("node4").setForeignSource("imported:").setForeignId("4");
        builder.addCategory(ac);
        builder.addInterface("192.168.4.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("192.168.4.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("192.168.4.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("alternate-node1").getAssetRecord().setAssetNumber("5");
        builder.addCategory(ac);
        builder.addCategory(catSwitches);
        builder.addInterface("10.1.1.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("10.1.1.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("10.1.1.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        builder.addNode("alternate-node2").getAssetRecord().setDisplayCategory("category1");
        builder.addCategory(ac);
        builder.addInterface("10.1.2.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("SNMP"));
        builder.addInterface("10.1.2.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getServiceType("ICMP"));
        builder.addService(this.getServiceType("HTTP"));
        builder.addInterface("10.1.2.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getServiceType("ICMP"));
        this.getNodeDao().save((Object)builder.getCurrentNode());
        this.getNodeDao().flush();
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(distPoller);
        event.setEventUei("uei.opennms.org/test");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.getEventDao().save((Object)event);
        this.getEventDao().flush();
        OnmsNotification notif = new OnmsNotification();
        notif.setEvent(event);
        notif.setTextMsg("This is a test notification");
        notif.setIpAddress("192.168.1.1");
        notif.setNode(this.m_node1);
        notif.setServiceType(this.getServiceType("ICMP"));
        this.getNotificationDao().save((Object)notif);
        this.getNotificationDao().flush();
        OnmsUserNotification userNotif = new OnmsUserNotification();
        userNotif.setUserId("TestUser");
        userNotif.setNotification(notif);
        this.getUserNotificationDao().save((Object)userNotif);
        this.getUserNotificationDao().flush();
        OnmsUserNotification userNotif2 = new OnmsUserNotification();
        userNotif2.setUserId("TestUser2");
        userNotif2.setNotification(notif);
        this.getUserNotificationDao().save((Object)userNotif2);
        this.getUserNotificationDao().flush();
        OnmsMonitoredService svc = this.getMonitoredServiceDao().get(Integer.valueOf(1), "192.168.1.1", "SNMP");
        OnmsOutage resolved = new OnmsOutage(new Date(), new Date(), event, event, svc, null, null);
        this.getOutageDao().save((Object)resolved);
        this.getOutageDao().flush();
        OnmsOutage unresolved = new OnmsOutage(new Date(), event, svc);
        this.getOutageDao().save((Object)unresolved);
        this.getOutageDao().flush();
        OnmsCategory category = new OnmsCategory();
        category.setName("some category");
        this.getCategoryDao().save((Object)category);
        this.getCategoryDao().flush();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_node1);
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr("192.168.1.1");
        alarm.setSeverity(OnmsSeverity.NORMAL);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
        OnmsMap map = new OnmsMap("DB_Pop_Test_Map", "admin");
        map.setBackground("fake_background.jpg");
        map.setAccessMode("RW");
        map.setType("U");
        map.setMapGroup("admin");
        this.getOnmsMapDao().save((Object)map);
        this.getOnmsMapDao().flush();
        OnmsMapElement mapElement = new OnmsMapElement(map, 1, "N", "Test Node", "unspecified", 0, 10);
        this.getOnmsMapElementDao().save((Object)mapElement);
        this.getOnmsMapElementDao().flush();
        DataLinkInterface dli = new DataLinkInterface(1, 1, 1, 1, "A", new Date());
        this.getDataLinkInterfaceDao().save((Object)dli);
        this.getDataLinkInterfaceDao().flush();
        DataLinkInterface dli2 = new DataLinkInterface(1, 2, 1, 1, "A", new Date());
        this.getDataLinkInterfaceDao().save((Object)dli2);
        this.getDataLinkInterfaceDao().flush();
        DataLinkInterface dli3 = new DataLinkInterface(2, 1, 1, 1, "A", new Date());
        this.getDataLinkInterfaceDao().save((Object)dli3);
        this.getDataLinkInterfaceDao().flush();
        OnmsAcknowledgment ack = new OnmsAcknowledgment();
        ack.setAckTime(new Date());
        ack.setAckType(AckType.UNSPECIFIED);
        ack.setAckAction(AckAction.UNSPECIFIED);
        ack.setAckUser("admin");
        this.getAcknowledgmentDao().save((Object)ack);
        this.getAcknowledgmentDao().flush();
    }

    private OnmsCategory getCategory(String categoryName) {
        OnmsCategory cat = this.getCategoryDao().findByName(categoryName);
        if (cat == null) {
            cat = new OnmsCategory(categoryName);
            cat.getAuthorizedGroups().add(categoryName + "Group");
            this.getCategoryDao().save((Object)cat);
            this.getCategoryDao().flush();
        }
        return cat;
    }

    private OnmsDistPoller getDistPoller(String localhost, String localhostIp) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.getDistPollerDao().get((Serializable)((Object)localhost));
        if (distPoller == null) {
            distPoller = new OnmsDistPoller(localhost, localhostIp);
            this.getDistPollerDao().save((Object)distPoller);
            this.getDistPollerDao().flush();
        }
        return distPoller;
    }

    private OnmsServiceType getServiceType(String name) {
        OnmsServiceType serviceType = this.getServiceTypeDao().findByName(name);
        if (serviceType == null) {
            serviceType = new OnmsServiceType(name);
            this.getServiceTypeDao().save((Object)serviceType);
            this.getServiceTypeDao().flush();
        }
        return serviceType;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.m_assetRecordDao = assetRecordDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public NotificationDao getNotificationDao() {
        return this.m_notificationDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.m_notificationDao = notificationDao;
    }

    public OutageDao getOutageDao() {
        return this.m_outageDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public UserNotificationDao getUserNotificationDao() {
        return this.m_userNotificationDao;
    }

    public void setUserNotificationDao(UserNotificationDao userNotificationDao) {
        this.m_userNotificationDao = userNotificationDao;
    }

    public OnmsNode getNode1() {
        return this.m_node1;
    }

    private void setNode1(OnmsNode node1) {
        this.m_node1 = node1;
    }

    public LocationMonitorDaoHibernate getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDaoHibernate locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public AcknowledgmentDao getAcknowledgmentDao() {
        return this.m_acknowledgmentDao;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.m_acknowledgmentDao = acknowledgmentDao;
    }
}

