/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.sql.SQLException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.dao.hibernate.AlarmDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class AuthorizationTest
extends AbstractTransactionalDaoTestCase {
    public void testAuthorizedAlarms() {
        List matching = this.getAlarmDao().findAll();
        AuthorizationTest.assertNotNull((Object)matching);
        AuthorizationTest.assertEquals((int)1, (int)matching.size());
        System.err.println(matching);
        this.enableAuthorizationFilter("NonExistentGroup");
        List matching2 = this.getAlarmDao().findAll();
        AuthorizationTest.assertNotNull((Object)matching2);
        AuthorizationTest.assertEquals((int)0, (int)matching2.size());
        System.err.println(matching2);
        this.disableAuthorizationFilter();
        List matching3 = this.getAlarmDao().findAll();
        AuthorizationTest.assertNotNull((Object)matching3);
        AuthorizationTest.assertEquals((int)1, (int)matching3.size());
        System.err.println(matching3);
    }

    public void testGetCategoriesWithAuthorizedGroups() {
        List categories = this.getCategoryDao().getCategoriesWithAuthorizedGroup("RoutersGroup");
        AuthorizationTest.assertNotNull((Object)categories);
        AuthorizationTest.assertEquals((int)1, (int)categories.size());
        AuthorizationTest.assertEquals((String)"Routers", (String)((OnmsCategory)categories.get(0)).getName());
    }

    public void enableAuthorizationFilter(final String ... groupNames) {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("authorizedOnly").setParameterList("userGroups", (Object[])groupNames);
                return null;
            }
        };
        ((AlarmDaoHibernate)this.getAlarmDao()).getHibernateTemplate().execute((HibernateCallback)cb);
    }

    public void disableAuthorizationFilter() {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.disableFilter("authorizedOnly");
                return null;
            }
        };
        ((AlarmDaoHibernate)this.getAlarmDao()).getHibernateTemplate().execute((HibernateCallback)cb);
    }
}

