/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import org.junit.Test;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;

public class AcknowledgmentDaoTest
extends AbstractTransactionalDaoTestCase {
    @Test
    public void testSaveUnspecified() {
        OnmsAcknowledgment ack = new OnmsAcknowledgment();
        ack.setAckTime(new Date());
        ack.setAckType(AckType.UNSPECIFIED);
        ack.setAckAction(AckAction.UNSPECIFIED);
        ack.setAckUser("not-admin");
        this.getAcknowledgmentDao().save((Object)ack);
        this.getAcknowledgmentDao().flush();
        Integer id = new Integer(ack.getId());
        ack = null;
        OnmsAcknowledgment ack2 = (OnmsAcknowledgment)this.getAcknowledgmentDao().get((Serializable)id);
        AcknowledgmentDaoTest.assertNotNull((Object)ack2);
        AcknowledgmentDaoTest.assertEquals((Object)id, (Object)ack2.getId());
        AcknowledgmentDaoTest.assertFalse((boolean)"admin".equals(ack2.getAckUser()));
        AcknowledgmentDaoTest.assertEquals((String)"not-admin", (String)ack2.getAckUser());
    }

    @Test
    public void testSaveWithAlarm() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.getEventDao().save((Object)event);
        OnmsNode node = (OnmsNode)this.getNodeDao().findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(new Integer(1));
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setAlarmAckTime(new Date());
        alarm.setAlarmAckUser("not-admin");
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm);
        this.getAcknowledgmentDao().save((Object)ack);
        Integer ackId = new Integer(ack.getId());
        ack = null;
        OnmsAcknowledgment ack2 = (OnmsAcknowledgment)this.getAcknowledgmentDao().get((Serializable)ackId);
        OnmsAlarm alarm2 = (OnmsAlarm)this.getAlarmDao().get((Serializable)ack2.getRefId());
        AcknowledgmentDaoTest.assertEquals((String)ack2.getAckUser(), (String)alarm2.getAlarmAckUser());
        AcknowledgmentDaoTest.assertEquals((Object)ack2.getAckTime(), (Object)alarm2.getAlarmAckTime());
    }
}

