/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.model.discovery.IPPollAddress;

public class DiscoveryConfigFactoryTest {
    @Test
    public void testAddToSpecificsFromURLViaURL() throws Exception {
        ArrayList specifics = new ArrayList();
        URL in = Thread.currentThread().getContextClassLoader().getResource("org/opennms/netmgt/config/validDiscoveryIncludeFile.txt");
        long timeout = 100L;
        boolean retries = true;
        DiscoveryConfigFactory.addToSpecificsFromURL(specifics, (String)in.toString(), (long)100L, (int)1);
        Assert.assertEquals((long)4L, (long)specifics.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((IPPollAddress)specifics.get(0)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"10.1.1.1", (Object)((IPPollAddress)specifics.get(1)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"10.2.1.1", (Object)((IPPollAddress)specifics.get(2)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"8.8.8.8", (Object)((IPPollAddress)specifics.get(3)).getAddress().getHostAddress());
    }

    @Test
    public void testAddToSpecificsFromURLViaStream() throws Exception {
        ArrayList specifics = new ArrayList();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/opennms/netmgt/config/validDiscoveryIncludeFile.txt");
        long timeout = 100L;
        boolean retries = true;
        DiscoveryConfigFactory.addToSpecificsFromURL(specifics, (InputStream)in, (long)100L, (int)1);
        Assert.assertEquals((long)4L, (long)specifics.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)((IPPollAddress)specifics.get(0)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"10.1.1.1", (Object)((IPPollAddress)specifics.get(1)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"10.2.1.1", (Object)((IPPollAddress)specifics.get(2)).getAddress().getHostAddress());
        Assert.assertEquals((Object)"8.8.8.8", (Object)((IPPollAddress)specifics.get(3)).getAddress().getHostAddress());
    }
}

