/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.dao.support.NullRrdStrategy;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;

public class ResourceTypeUtilsTest {
    private FileAnticipator m_fileAnticipator;
    private File m_snmp;
    private File m_node;
    private File m_intf;

    @Before
    public void setUp() throws Exception {
        this.m_fileAnticipator = new FileAnticipator();
        RrdUtils.setStrategy((RrdStrategy)new NullRrdStrategy());
    }

    @After
    public void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
    }

    @Test
    public void testLoadPropertiesNullRrdDirectory() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("rrdDirectory argument must not be null"));
        try {
            ResourceTypeUtils.getStringProperties(null, (String)"something");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testLoadPropertiesNullRelativePath() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("relativePath argument must not be null"));
        try {
            ResourceTypeUtils.getStringProperties((File)new File(""), null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testLoadPropertiesEmpty() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "", false);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        Assert.assertNotNull((String)"properties should not be null", (Object)p);
        Assert.assertEquals((String)"properties size", (long)0L, (long)p.size());
    }

    @Test
    public void testLoadPropertiesNonEmpty() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "foo=bar", false);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        Assert.assertNotNull((String)"properties should not be null", (Object)p);
        Assert.assertEquals((String)"properties size", (long)1L, (long)p.size());
        Assert.assertNotNull((String)"property 'foo' should exist", (Object)p.get("foo"));
        Assert.assertEquals((String)"property 'foo' value", (Object)"bar", (Object)p.get("foo"));
    }

    @Test
    public void testLoadPropertiesDoesNotExist() throws Exception {
        OnmsResource childResource = this.createResource();
        this.createPropertiesFile(childResource, "", true);
        Properties p = ResourceTypeUtils.getStringProperties((File)this.m_fileAnticipator.getTempDir(), (String)"snmp/1/eth0");
        Assert.assertNull((String)"no properties file was created, so the properties object should be null", (Object)p);
    }

    @Test
    public void testGetAttributesAtRelativePathWithBogusDirectory() {
        File bogusRrdDirectory = new File("/foo/bogus/blam/cheese/this/really/should/never/exist");
        Assert.assertFalse((String)("bogus RRD directory " + bogusRrdDirectory + " should not exist"), (boolean)bogusRrdDirectory.exists());
        ResourceTypeUtils.getAttributesAtRelativePath((File)bogusRrdDirectory, (String)"also-should-never-exist");
    }

    @Test
    public void testUpdateFileOutsideResourceTypeUtils() throws Exception {
        System.setProperty("org.opennms.utils.propertiesCache.enableCheckFileModified", "true");
        File resourceDir = new File("target/");
        File propertiesFile = new File(resourceDir, "strings.properties");
        propertiesFile.delete();
        ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)"2012", (String)"year");
        Assert.assertEquals((Object)"2012", (Object)ResourceTypeUtils.getStringProperty((File)resourceDir, (String)"year"));
        Thread.sleep(1000L);
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        properties.setProperty("year", "2013");
        properties.store(new FileWriter(propertiesFile), "Updated!");
        Assert.assertEquals((Object)"2013", (Object)ResourceTypeUtils.getStringProperty((File)resourceDir, (String)"year"));
    }

    private OnmsResource createResource() {
        OnmsResource topResource = new OnmsResource("1", "Node One", (OnmsResourceType)new MockResourceType(), new HashSet(0));
        HashSet<RrdGraphAttribute> attributes = new HashSet<RrdGraphAttribute>(1);
        attributes.add(new RrdGraphAttribute("foo", "1/eth0", "foo.jrb"));
        OnmsResource childResource = new OnmsResource("eth0", "Interface eth0", (OnmsResourceType)new MockResourceType(), attributes);
        childResource.setParent(topResource);
        return childResource;
    }

    private File createPropertiesFile(OnmsResource childResource, String propertiesContent, boolean onlyCreateParentDirectories) throws IOException {
        this.m_fileAnticipator.initialize();
        this.m_snmp = this.m_fileAnticipator.tempDir("snmp");
        this.m_node = this.m_fileAnticipator.tempDir(this.m_snmp, childResource.getParent().getName());
        this.m_intf = this.m_fileAnticipator.tempDir(this.m_node, childResource.getName());
        if (onlyCreateParentDirectories) {
            return new File(this.m_intf, "strings.properties");
        }
        return this.m_fileAnticipator.tempFile(this.m_intf, "strings.properties", propertiesContent);
    }
}

